% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{posterior_epred_ordbeta.brmsfit}
\alias{posterior_epred_ordbeta.brmsfit}
\alias{posterior_epred_ordbeta}
\title{Calculate Probability of Response Components}
\usage{
\method{posterior_epred_ordbeta}{brmsfit}(
  object,
  component = "all",
  newdata = NULL,
  re_formula = NULL,
  re.form = NULL,
  resp = NULL,
  dpar = NULL,
  nlpar = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  sort = FALSE,
  ...
)
}
\arguments{
\item{object}{An ordbetareg/brms object}

\item{component}{The type of response component, i.e., the probability
of the bottom end of the scale, the top end, or the middle (i.e.)
continuous values.}

\item{newdata}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{re_formula}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{re.form}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{resp}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{dpar}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{nlpar}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{ndraws}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{draw_ids}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{sort}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}

\item{...}{see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}}
}
\value{
An S x N matrix where S is the number of posterior draws
and N is the number of observations.
}
\description{
This function is an alternative to the \code{brms} default \code{posterior_epred}
to allow for predictions of
the probability of the bottom, top, or middle (i.e. continuous) parts
of the response. Useful when wanting to understand what the effect of a covariate
is on bottom or top values of the scale.
}
\details{
To predict the top, bottom, or "middle" (i.e. continuous) components of the
response, set the \code{component} argument to "top", "bottom" or "continuous". By
default, \code{component} is set to "all", which will replicate behavior of the
default \code{posterior_epred} function.

All other arguments besides \code{component} are the same as the
standard generic \code{posterior_predict}.
For more information on the relevant arguments for \code{posterior_epred},
see \link[brms:posterior_epred.brmsfit]{brms::posterior_epred}.
}
\examples{

data('ord_fit_mean')

# use function to calculate probability of top end of scale

pr_1s <- posterior_epred_ordbeta(ord_fit_mean,component="top")

# use function to calculate probability of bottom end of scale

pr_0s <- posterior_epred_ordbeta(ord_fit_mean,component="top")

# use function to calculate probability of continuous /
# beta-distributed part of scale

pr_beta <- posterior_epred_ordbeta(ord_fit_mean,component="top")

}
