% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_binary_decisions.R
\name{add_binary_decisions}
\alias{add_binary_decisions}
\title{Add binary decisions}
\usage{
add_binary_decisions(x)
}
\arguments{
\item{x}{\linkS4class{ProjectProblem} object.}
}
\value{
\linkS4class{ProjectProblem} object with the decisions
added to it.
}
\description{
Add a binary decision to a project prioritization \code{\link[=problem]{problem()}}.
This is the conventional decision of either prioritizing funding
for a management action or not.
}
\details{
Project prioritization problems involve making decisions about
how funding will be allocated to management actions.
Only a single decision should be added to a \code{ProjectProblem} object.
If no decision is added to a problem then this decision type will
be used by default. Currently, this is the only supported decision type.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with maximum richness objective, $200 budget, and
# binary decisions
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions()

# print problem
print(p)

\dontrun{
# solve problem
s <- solve(p)

# print solution
print(s)

# plot solution
plot(p, s)
}
}
\seealso{
\link{decisions}.
}
