% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_font}
\alias{wb_add_font}
\title{Modify font in a cell region}
\usage{
wb_add_font(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  name = "Aptos Narrow",
  color = wb_color(hex = "FF000000"),
  size = "11",
  bold = "",
  italic = "",
  outline = "",
  strike = "",
  underline = "",
  charset = "",
  condense = "",
  extend = "",
  family = "",
  scheme = "",
  shadow = "",
  vert_align = "",
  update = FALSE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object}

\item{sheet}{the worksheet}

\item{dims}{the cell range}

\item{name}{Font name: default \code{"Aptos Narrow"}.}

\item{color}{A \code{\link[=wb_color]{wb_color()}}, the color of the font. Default is "FF000000".}

\item{size}{Font size: default is \code{11}.}

\item{bold}{Logical, whether the font should be bold.}

\item{italic}{Logical, whether the font should be italic.}

\item{outline}{Logical, whether the font should have an outline.}

\item{strike}{Logical, whether the font should have a strikethrough.}

\item{underline}{underline, "single" or "double", default: ""}

\item{charset}{Character, the character set to be used. The list of valid IDs can be found in the \strong{Details} section of \code{\link[=fmt_txt]{fmt_txt()}}.}

\item{condense}{Logical, whether the font should be condensed.}

\item{extend}{Logical, whether the font should be extended.}

\item{family}{Character, the font family. Default is "2" (modern). "0" (auto), "1" (roman), "2" (swiss), "3" (modern), "4" (script), "5" (decorative). # 6-14 unused}

\item{scheme}{Character, the font scheme. Valid values are "minor", "major", "none". Default is "minor".}

\item{shadow}{Logical, whether the font should have a shadow.}

\item{vert_align}{Character, the vertical alignment of the font. Valid values are "baseline", "superscript", "subscript".}

\item{update}{Logical/Character if logical, all elements are assumed to be selected, whereas if character, only matching elements are updated. This will not alter strings styled with \code{\link[=fmt_txt]{fmt_txt()}}.}

\item{...}{...}
}
\value{
A \code{wbWorkbook}, invisibly
}
\description{
Modify the font in a cell region with more precision
You can specify the font in a cell with other cell styling functions,
but \code{wb_add_font()} gives you more control.
}
\details{
\code{wb_add_font()} provides all the options openxml accepts for a font node,
not all have to be set. Usually \code{name}, \code{size} and \code{color} should be what the user wants.
Setting \code{update} to \code{NULL} removes the style and resets the cell to the workbook default.
}
\examples{
 wb <- wb_workbook()
 wb <- wb_add_worksheet(wb, "S1")
 wb <- wb_add_data(wb, "S1", mtcars)
 wb <- wb_add_font(wb, "S1", "A1:K1", name = "Arial", color = wb_color(theme = "4"))
# With chaining
 wb <- wb_workbook()$add_worksheet("S1")$add_data("S1", mtcars)
 wb$add_font("S1", "A1:K1", name = "Arial", color = wb_color(theme = "4"))

# Update the font color
 wb$add_font("S1", "A1:K1", color = wb_color("orange"), update = c("color"))
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_cell_style}}
}
\concept{styles}
