% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_points.R
\name{oc_points}
\alias{oc_points}
\alias{oc_points.numeric}
\alias{oc_points.data.frame}
\title{List of points for OpenCage queries}
\usage{
oc_points(...)

\method{oc_points}{numeric}(latitude, longitude, ...)

\method{oc_points}{data.frame}(data, latitude, longitude, ...)
}
\arguments{
\item{...}{Ignored.}

\item{latitude, longitude}{Numeric vectors of latitude and longitude values.}

\item{data}{A \code{data.frame} containing at least 2 columns with \code{latitude} and
\code{longitude} values.}
}
\value{
A list of points. Each point is a named vector of length 2 containing
a latitude/longitude coordinate pair.
}
\description{
Create a list of points (latitude/longitude coordinate pairs) for OpenCage
queries.
}
\examples{
oc_points(-21.01404, 55.26077)

xdf <-
  data.frame(
    place = c("Hamburg", "Los Angeles"),
    lat = c(53.5503, 34.0536),
    lon = c(10.0006, -118.2427)
  )
oc_points(
  data = xdf,
  latitude = lat,
  longitude = lon
)

# create a list column with points with dplyr
library(dplyr)
xdf \%>\%
  mutate(
    points =
      oc_points(
        lat,
        lon
      )
  )

}
