% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollingMean.R
\name{rollingMean}
\alias{rollingMean}
\title{Calculate rolling mean pollutant values}
\usage{
rollingMean(
  mydata,
  pollutant = "o3",
  width = 8L,
  type = "default",
  data.thresh = 75,
  align = c("centre", "center", "left", "right"),
  new.name = NULL,
  ...
)
}
\arguments{
\item{mydata}{A data frame containing a \code{date} field. \code{mydata} must contain a
\code{date} field in \code{Date} or \code{POSIXct} format. The input time series must be
regular, e.g., hourly, daily.}

\item{pollutant}{The name of a pollutant, e.g., \code{pollutant = "o3"}.}

\item{width}{The averaging period (rolling window width) to use, e.g., \code{width = 8} will generate 8-hour rolling mean values when hourly data are
analysed.}

\item{type}{Used for splitting the data further. Passed to \code{\link[=cutData]{cutData()}}.}

\item{data.thresh}{The \% data capture threshold. No values are calculated if
data capture over the period of interest is less than this value. For
example, with \code{width = 8} and \code{data.thresh = 75} at least 6 hours are
required to calculate the mean, else \code{NA} is returned.}

\item{align}{Specifies how the moving window should be aligned. \code{"right"}
means that the previous hours (including the current) are averaged.
\code{"left"} means that the forward hours are averaged. \code{"centre"} (or
\code{"center"} - the default) centres the current hour in the window.}

\item{new.name}{The name given to the new column. If not supplied it will
create a name based on the name of the pollutant and the averaging period
used.}

\item{...}{Additional parameters passed to \code{\link[=cutData]{cutData()}}. For use with \code{type}.}
}
\description{
This is a utility function mostly designed to calculate rolling mean
statistics relevant to some pollutant limits, e.g., 8 hour rolling means for
ozone and 24 hour rolling means for PM10. However, the function has a more
general use in helping to display rolling mean values in flexible ways with
the rolling window width left, right or centre aligned. The function will try
and fill in missing time gaps to get a full time sequence but return a data
frame with the same number of rows supplied.
}
\examples{
# rolling 8-hour mean for ozone
mydata <- rollingMean(mydata,
  pollutant = "o3", width = 8, new.name =
    "rollingo3", data.thresh = 75, align = "right"
)
}
\author{
David Carslaw
}
