% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{read_Simmap_Rev}
\alias{read_Simmap_Rev}
\title{Reading stochastic character maps file from ReVBayes}
\usage{
read_Simmap_Rev(file, start = 1, end = 1, save = NULL)
}
\arguments{
\item{file}{character. Path to the RevBayes file.}

\item{start}{integer. First tree of the sample to start reading the RevBayes file.}

\item{end}{integer. Last tree of the sample to finish reading the RevBayes file.}

\item{save}{character. Name to save output file.}
}
\value{
A tree in 'phylip' format.
}
\description{
Imports stochastic character maps file from RevBayes into R.
}
\examples{
rev_stm <- "Iteration\t1\t2\t3\tsimmap\n
0\t{1,2.0}\t((spp1:{1,4.0:0,4.0},spp2:{1,2.0:0,6.0}):{1,0.5});\n
1\t{1,2.0}\t((spp1:{1,2.0:0,6.0},spp2:{1,3.0:0,5.0}):{1,0.5});\n
3\t{1,2.0}\t((spp1:{1,2.0:0,6.0},spp2:{1,3.0:0,5.0}):{1,0.5});"
stm <- read_Simmap_Rev(textConnection(rev_stm, "r"), start = 0, end = 3, save = NULL)
stm <- phytools::read.simmap(text = stm, format = "phylip")
phytools::plotSimmap(stm[[1]])

}
\author{
Sergei Tarasov
}
