% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{remove_terms_with_less_than_n_occurrences}
\alias{remove_terms_with_less_than_n_occurrences}
\title{Remove terms with less than certain number of occurrences}
\usage{
remove_terms_with_less_than_n_occurrences(
  ontology,
  term_sets,
  n,
  terms = unique(unlist(term_sets))
)
}
\arguments{
\item{ontology}{\code{ontology_index} object}

\item{term_sets}{List of character vectors of ontological term IDs}

\item{n}{Integer}

\item{terms}{Character vector of ontological terms}
}
\value{
Character vector
}
\description{
Remove terms with less than certain number of occurrences
}
\examples{
library(ontologyIndex)
data(hpo)
remove_terms_with_less_than_n_occurrences(hpo, 
term_sets=list("HP:0001873", "HP:0001902"), n=2)
}
\seealso{
\code{\link{n_most_frequent_terms}}
}
