% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance-points.R
\name{balance_points}
\alias{balance_points}
\title{balance_points}
\usage{
balance_points(pattern, n, verbose = TRUE)
}
\arguments{
\item{pattern}{ppp object.}

\item{n}{Either an integer or a ppp object.}

\item{verbose}{Print messages.}
}
\value{
ppp
}
\description{
Balance number of points
}
\details{
The function balances out the number of points in the input pattern to either
the provided number of points as integer or the same number of points if a
\code{ppp} object is provided.
}
\examples{
set.seed(42)
input <- spatstat.random::rpoispp(lambda = 100)
input_b <- spatstat.random::rpoispp(lambda = 100)

balance_points(pattern = input, n = 110)
balance_points(pattern = input, n = input_b)

}
