% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{check_ok_to_store}
\alias{check_ok_to_store}
\title{Check if the package has permission to store files on the user's computer}
\usage{
check_ok_to_store(
  ask = FALSE,
  message = "The onetime package requests to store files in '\%s'.",
  confirm_prompt = "Is this OK? [Yn] ",
  confirm_answers = c("Y", "y", "Yes", "yes", "YES"),
  default_answer = "Y"
)
}
\arguments{
\item{ask}{\code{TRUE} to ask the user for permission.}

\item{message}{Message to display to the user.}

\item{confirm_prompt}{Character string. Question to prompt the user to hide
the message in future.}

\item{confirm_answers}{Character vector. Answers which will cause
the message to be hidden in future.}

\item{default_answer}{Character string. Default answer if user
simply presses return.}
}
\value{
\code{TRUE} if:
\itemize{
\item We already have permission;
\item \code{ask} is \code{TRUE}, we are in an interactive session and the user
gives us permission;
\item \code{options("onetime.dir")} is set to a non-\code{NULL} value.
}

Otherwise \code{FALSE}.
}
\description{
The onetime package works by storing lockfiles in
\code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}. It won't do so unless permission has been
granted. Before using \code{onetime} functions, package authors should call
\code{check_ok_to_store(ask = TRUE)} in an interactive session, in functions which
are called directly from the command line.
}
\details{
If your package is not used interactively, a workaround is to call
\code{\link[=set_ok_to_store]{set_ok_to_store()}}. This grants permission and prints an informative
message. Package owners should \emph{only} call this if they cannot ask
explicitly.

\code{\link[=onetime_message_confirm]{onetime_message_confirm()}} is an exception: by default it doesn't require
global permission to store files, since the user accepting "Don't show this
again" is considered sufficient.

\code{ask = TRUE} asks the user, if he or she has not already given permission,
and if the session is \code{\link[=interactive]{interactive()}}.

Remaining parameters are passed to \code{\link[=onetime_message_confirm]{onetime_message_confirm()}} in this case,
and ignored otherwise. A \code{"\%s"} in \code{message} will be replaced by the
onetime storage directory.
}
\examples{

check_ok_to_store()

}
