% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim_position.R
\name{anim_position}
\alias{anim_position}
\title{Animate the position of an element}
\usage{
anim_position(x = NULL, y = NULL, easing_fn = NULL, initial = FALSE)
}
\arguments{
\item{x, y}{The position of the element, expressed as \code{x} and \code{y}, at the
keyframe time (given as the LHS value in the \code{\link[=anims]{anims()}} call).}

\item{easing_fn}{The timing or easing function to use for the animation. If
not provided, the \code{\link[=linear]{linear()}} timing function will be used (which is doesn't
use any easing in the animation, just a linear movement). The other timing
and easing functions are: \code{\link[=step_start]{step_start()}}, \code{\link[=step_end]{step_end()}}, \code{\link[=ease_in]{ease_in()}},
\code{\link[=ease_out]{ease_out()}}, and \code{\link[=ease_in_out]{ease_in_out()}}.}

\item{initial}{Should this position be the initial position of the element?
If so, use \code{TRUE} and any values provided to \code{x} and \code{y} will be
disregarded.}
}
\value{
An \code{anim_opacity} object, which is to be used as part of an \code{\link[=anims]{anims()}}
call.
}
\description{
Within an \code{\link[=anims]{anims()}} call, itself passed to any \code{anims} argument, the
\code{anim_position()} function can be used to express an animation where the
position of the target element changes with time.
}
\examples{
if (interactive()) {

# Basic animation of an element's
# position (moving to a new `x` and
# `y` position)
SVG(width = 300, height = 300) \%>\%
  svg_rect(
    x = 50, y = 50,
    width = 50, height = 50,
    attrs = svg_attrs_pres(
      stroke = "magenta",
      fill = "lightblue"
    ),
    anims = anims(
      2.0 ~ anim_position(x = 100, y = 50)
    )
  )
}

}
