% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{load_custom_data}
\alias{load_custom_data}
\title{Load custom data from inst/extdata or a user-specified path}
\format{
A data frame with 55 weekly observations and 19 columns, including headers. The first column represents the date in the format MM/DD/YYYY, while all other columns display weekly percentage changes with five-decimal precision.
}
\source{
Example dataset compiled from the following public sources:
- Crude oil supply/demand metrics (FieldProduction, RefinerNetInput, OperableCapacity, Imports, StocksExcludingSPR): https://www.eia.gov
- API gravity and Rig Count: Extracted from industry reports
- S&P 500 Index (SPX): https://fred.stlouisfed.org/series/SP500
- CFTC positioning data (NonCommercialLong, CommercialShort, OpenInterest, etc.): https://www.cftc.gov (NYMEX short format)
- TotalLong and TotalShort = NonCommercial (L/S) + Spread (L/S) + Commercial (L/S)
}
\usage{
load_custom_data(
  data = "crudeoildata.csv",
  custom_path = NULL,
  exclude_first_column = FALSE
)
}
\arguments{
\item{data}{The name of the data file to load (default: "crudeoildata.csv").}

\item{custom_path}{An optional custom file path. If provided, it overrides the default file path.}

\item{exclude_first_column}{Logical value indicating whether to exclude the first column from the loaded data (default: FALSE).}
}
\value{
A data frame containing the loaded data.
}
\description{
This function loads custom data from the inst/extdata directory of the package or
a designated path provided by the user.
}
\examples{
\dontrun{
# Load custom data with default options
df <- load_custom_data()

# Load data from a custom file path and exclude the first column (e.g., a Date column)
df <- load_custom_data(
  data = "crudeoildata.csv",
  custom_path = "path/to/custom/crudeoildata.csv",
  exclude_first_column = TRUE
)

# Load default custom data and exclude the first column
df <- load_custom_data(exclude_first_column = TRUE)
}

}
