% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_reg_offset.R
\name{poisson_reg_offset}
\alias{poisson_reg_offset}
\title{Poisson regression models with offsets}
\usage{
poisson_reg_offset(
  mode = "regression",
  penalty = NULL,
  mixture = NULL,
  engine = "glm_offset"
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{penalty}{A non-negative number representing the total
amount of regularization (\code{glmnet} only).}

\item{mixture}{A number between zero and one (inclusive) giving the
proportion of L1 regularization (i.e. lasso) in the model.
\itemize{
\item \code{mixture = 1} specifies a pure lasso model,
\item \code{mixture = 0}  specifies a ridge regression model, and
\item \verb{0 < mixture < 1} specifies an elastic net model, interpolating lasso and ridge.
}

Available for \code{glmnet} and \code{spark} only.}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\value{
A model specification object with the classes \code{poisson_reg_offset}
and \code{model_spec}.
}
\description{
\code{poisson_reg_offset()} defines a generalized linear model of count data with
an offset that follows a Poisson distribution.
}
\details{
This function is similar to \code{\link[parsnip:poisson_reg]{parsnip::poisson_reg()}} except that
specification of an offset column is required.
}
\examples{
parsnip::show_model_info("poisson_reg_offset")

poisson_reg_offset()

}
\seealso{
\code{\link[parsnip:poisson_reg]{parsnip::poisson_reg()}}
}
