% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_markov_chain.R
\name{simulate_markov_chain}
\alias{simulate_markov_chain}
\title{Simulate Markov chain}
\usage{
simulate_markov_chain(Gamma, T, delta = oeli::stationary_distribution(Gamma))
}
\arguments{
\item{Gamma}{[\code{matrix()}]\cr
A transition probability matrix.}

\item{T}{[\code{integer(1)}]\cr
The length of the Markov chain.}

\item{delta}{[\code{numeric()}]\cr
A probability vector, the initial distribution.

The stationary distribution is used by default.}
}
\value{
A \code{numeric} vector of length \code{T} with states.
}
\description{
This function simulates a Markov chain.
}
\examples{
Gamma <- matrix(c(0.8, 0.2, 0.3, 0.7), byrow = TRUE, nrow = 2)
delta <- c(0.6, 0.4)
simulate_markov_chain(Gamma = Gamma, T = 20, delta = delta)
}
\seealso{
Other simulation helpers: 
\code{\link{Simulator}},
\code{\link{correlated_regressors}()},
\code{\link{ddirichlet_cpp}()},
\code{\link{dmixnorm_cpp}()},
\code{\link{dmvnorm_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{dwishart_cpp}()},
\code{\link{gaussian_tv}()}
}
\concept{simulation helpers}
\keyword{simulation}
