% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_sort.R
\docType{methods}
\name{hal_sort}
\alias{hal_sort}
\title{Sort Results}
\usage{
hal_sort(query, field, decreasing = FALSE, ...)

hal_sort(query, field, decreasing = FALSE, ...)
}
\arguments{
\item{query}{An object of class \code{HALQuery} (typically returned by \code{\link[=hal_query]{hal_query()}}).}

\item{field}{A \code{\link{character}} string specifying the field to be used to sort
the results.}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort be increasing or
decreasing?}

\item{...}{Currently not used.}
}
\value{
An object of class \code{\link[=hal_query]{HALQuery}}.
}
\description{
Sort Results
}
\examples{
## Select fields
(q <- hal_query() |> hal_sort("docid"))

## Update query
hal_sort(q, "producedDate_tdate", decreasing = TRUE)
}
\seealso{
Other query tools: 
\code{\link{hal_facet}()},
\code{\link{hal_filter}()},
\code{\link{hal_group}()},
\code{\link{hal_query}()},
\code{\link{hal_select}()},
\code{\link{operators}}
}
\author{
N. Frerebeau
}
\concept{query tools}
