% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_count.R
\name{hal_count}
\alias{hal_count}
\alias{hal_count.HALQuery}
\title{Count}
\usage{
hal_count(query, ...)

\method{hal_count}{HALQuery}(query, path = "search", instance = NULL, ...)
}
\arguments{
\item{query}{An object of class \code{HALQuery} (typically returned by \code{\link[=hal_query]{hal_query()}}).}

\item{...}{Currently not used.}

\item{path}{A \code{\link{character}} string giving the API name
(defaults to "\code{search}").}

\item{instance}{A \code{\link{character}} string giving the HAL portal name.}
}
\value{
An \code{\link{integer}} (the number of results).
}
\description{
Count
}
\examples{
\dontrun{
## Simple search
topic <- list("archéologie", "Celtes", "France") # Combined with AND
## Get the first ten results
hal_query(topic) |>
  hal_search(limit = 10) |>
  as.data.frame()
## Get all results
hal_query(topic) |>
  hal_search(limit = 30, cursor = TRUE) |>
  as.data.frame()

## Get a list of archaeological journals
topic <- c("archéologie", "archaeology", "archäologie") # Combined with OR
hal_query(topic) |>
  hal_select("title_s", "issn_s") |>
  hal_filter("" \%TO\% "*" \%IN\% "issn_s") |>
  hal_sort("title_s") |>
  hal_search(path = "ref", instance = "journal") |>
  as.data.frame()

## Get a list of archaeological laboratories
## (only joint laboratories of the CNRS and a French university)
topic <- list("archéologie" \%IN\% "text", "UMR" \%IN\% "code_t")
hal_query(topic) |>
  hal_select("name_s", "acronym_s", "code_s") |>
  hal_filter("VALID" \%IN\% "valid_s") |>
  hal_sort("acronym_s", decreasing = TRUE) |>
  hal_search(path = "ref", instance = "structure", limit = 15) |>
  as.data.frame()
}
}
\seealso{
Other search tools: 
\code{\link{hal_download}()},
\code{\link{hal_search}()}
}
\author{
N. Frerebeau
}
\concept{search tools}
