% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.odv.R
\name{read.ctd.odv}
\alias{read.ctd.odv}
\title{Read a "ctd" File in ODV Format}
\usage{
read.ctd.odv(
  file,
  columns = NULL,
  station = NULL,
  missingValue,
  deploymentType,
  encoding = "latin1",
  monitor = FALSE,
  debug = getOption("oceDebug"),
  processingLog,
  ...
)
}
\arguments{
\item{file}{either a connection or a character value naming a file.
For \code{\link[=read.ctd.sbe]{read.ctd.sbe()}} and \code{\link[=read.ctd.woce]{read.ctd.woce()}}, this may be a
wildcard (e.g. \code{"*.cnv"} or \code{"*.csv"}) in which case the return
value is a vector containing CTD objects created by reading the files from
\code{\link[=list.files]{list.files()}} with \code{pattern} set to the specified wildcard
pattern.}

\item{columns}{an optional \link{list} that can be used to convert unrecognized
data names to resultant variable names.  This is used only by
\code{\link[=read.ctd.sbe]{read.ctd.sbe()}} and \code{\link[=read.ctd.odf]{read.ctd.odf()}}. For example,
if a data file named salinity as \code{"SAL"}, then using

\if{html}{\out{<div class="sourceCode">}}\preformatted{d <- read.ctd(f, columns=list(
    salinity=list(name="SAL",
                  unit=list(unit=expression(),
                  scale="PSS-78"))))
}\if{html}{\out{</div>}}

would assign the \code{"SAL"} column to the \code{salinity} entry in the data
slot of the CTD object returned by the \verb{read.*} function.}

\item{station}{optional character string containing an identifying name or
number for the station. This can be useful if the routine cannot determine the
name automatically, or if another name is preferred.}

\item{missingValue}{optional missing-value flag; data matching this value will
be set to \code{NA} upon reading. If this is provided, then it overrules any
missing-value flag found in the data. For Seabird (\code{.cnv}) files, there is
usually no need to set \code{missingValue}, because it can be inferred from the
header (typically as -9.990e-29). Set \code{missingValue=NULL} to turn off
missing-value detection, even in \code{.cnv} files that contain missing-value
codes in their headers. If \code{missingValue} is not specified,
then an attempt is made to infer such a value from the data, by testing
whether salinity and/or temperature has a minimum that is under -8 in value;
this should catch common values in files, without false positives. A warning
will be issued in this case, and a note inserted in the processing log of
the return value.}

\item{deploymentType}{character string indicating the type of deployment. Use
\code{"unknown"} if this is not known, \code{"profile"} for a profile (in
which the data were acquired during a downcast, while the device was lowered
into the water column, perhaps also including an upcast; \code{"moored"} if
the device is installed on a fixed mooring, \code{"thermosalinograph"} (or
\code{"tsg"}) if the device is mounted on a moving vessel, to record
near-surface properties, or \code{"towyo"} if the device is repeatedly
lowered and raised.}

\item{encoding}{a character value that indicates the encoding to be used for
this data file, if it is textual.  The default value for most functions is
\code{"latin1"}, which seems to be suitable for files containing text written in
English and French.}

\item{monitor}{boolean, set to \code{TRUE} to provide an indication of
progress.  This is useful if \code{filename} is a wildcard.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}

\item{processingLog}{if provided, the action item to be stored in the log.
This is typically only provided for internal calls; the default that it provides is
better for normal calls by a user.}

\item{...}{additional arguments, passed to called routines.}
}
\value{
This function returns a \linkS4class{ctd} object.
}
\description{
Read a "ctd" File in ODV Format
}
\details{
\code{\link[=read.ctd.odv]{read.ctd.odv()}} attempts to read files stored in ODV format,
used by some European data providers. This works only crudely, as of
2020-05-17. In particular, the translation from ODV parameter names to oce
names is \emph{very} limited.  For example, only one of the dozens of possibilities
for variants of phosphate is handled at the moment, and that is because
this was the variant supplied in a test file sent to the author on
2020-05-16.  It is unlikely that full support of ODV files will
become available in \code{\link[=read.ctd.odv]{read.ctd.odv()}}, given the lack of a comprehensive source
listing ODV variable names and their meanings, and low user
interest.
}
\references{
\enumerate{
\item \verb{https://www.bodc.ac.uk/resources/delivery_formats/odv_format/} describes
the \code{ODV} format.
\item \verb{https://vocab.nerc.ac.uk/collection/P07/current/} may be
worth consulting for variable names.
}
}
\seealso{
Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd}},
\code{\link{ctd-class}},
\code{\link{ctd.cnv.gz}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdFindProfilesRBR}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv.gz}},
\code{\link{d200321-001.ctd.gz}},
\code{\link{d201211_0011.cnv.gz}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.saiv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\author{
Dan Kelley
}
\concept{things related to ctd data}
