% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{as.adp}
\alias{as.adp}
\title{Create an adp Object}
\usage{
as.adp(
  time,
  distance,
  v,
  a = NULL,
  q = NULL,
  orientation = "upward",
  coordinate = "enu"
)
}
\arguments{
\item{time}{of observations in POSIXct format}

\item{distance}{to centre of bins}

\item{v}{array of velocities, with first index for time, second for bin number, and third for beam number}

\item{a}{amplitude, a \code{\link[=raw]{raw()}} array with dimensions matching \code{u}}

\item{q}{quality, a \code{\link[=raw]{raw()}} array with dimensions matching \code{u}}

\item{orientation}{a string indicating sensor orientation, e.g. \code{"upward"} and \code{"downward"}}

\item{coordinate}{a string indicating the coordinate system, \code{"enu"}, \code{"beam"}, \code{"xy"}, or \code{"other"}}
}
\value{
An \linkS4class{adp} object.
}
\description{
Create an adp Object
}
\details{
Construct an \linkS4class{adp} object.  Only a basic
subset of the typical \code{data} slot is represented in the arguments
to this function, on the assumption that typical usage in reading data
is to set up a nearly-blank \linkS4class{adp} object, the \code{data}
slot of which is then inserted.  However, in some testing situations it
can be useful to set up artificial \code{adp} objects, so the other
arguments may be useful.
}
\examples{
data(adp)
t <- adp[["time"]]
d <- adp[["distance"]]
v <- adp[["v"]]
a <- as.adp(time = t, distance = d, v = v)
\donttest{
plot(a)
}

}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp}},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOther}()},
\code{\link{enuToOtherAdp}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp}()},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.aquadopp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnu}()},
\code{\link{toEnuAdp}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnu}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnuAdpAD2CP}()}
}
\author{
Dan Kelley
}
\concept{things related to adp data}
