% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trees.R
\name{get_trees}
\alias{get_trees}
\title{Extract posterior transmission trees}
\usage{
get_trees(out, kappa = FALSE, t_inf = FALSE, ...)
}
\arguments{
\item{out}{A data frame of class \code{outbreaker_chains}.}

\item{kappa}{Logical. If \code{TRUE}, includes \code{kappa} values in the output. Default is \code{FALSE}.}

\item{t_inf}{Logical. If \code{TRUE}, includes infection times (\code{t_inf}) in the output. Default is \code{FALSE}.}

\item{...}{Additional vectors to include as columns in the output. Must be given in the same order as used in \code{outbreaker()}.}
}
\value{
A list of data frames, one per posterior sample. Each data frame has at least 'from' and 'to' columns.
}
\description{
Generates a list of data frames representing posterior transmission trees from an
\code{outbreaker_chains} object. Each tree contains 'from' and 'to' columns, and may
optionally include \code{kappa}, \code{t_inf}, and user-supplied columns.
}
\examples{
get_trees(out, id = linelist$id,
               name = linelist$name,
               group = linelist$group,
               onset = linelist$onset)
}
