% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNPJ.R, R/CPF.R, R/RENAVAN.R, R/numbersBR.R
\name{CNPJ}
\alias{CNPJ}
\alias{CPF}
\alias{RENAVAN}
\alias{numbers}
\title{Functions to create brazilian numbers objects}
\usage{
CNPJ(x)

CPF(x)

RENAVAN(x)
}
\arguments{
\item{x}{the identification number as numeric or character}
}
\value{
A S3 class representing the brazilian number: CNPJ, CPF, RENAVAN
}
\description{
The brazilian numbers used to identify individuals, vehicles, companies and
any other things have their own S3 classes.
}
\examples{
CNPJ(c(13515463000138, 3737211000108, 360305000104, 66670000100))
CNPJ(c("13.515.463/0001-38", "03.737.211/0001-08", "00.360.305/0001-04", "00.066.670/0001-00"))
CPF(c(68194359406, 1239157673, 52008275582))
CPF(c("681.943.594-06", "012.391.576-73", "520.082.755-82"))
RENAVAN(c(75320797785, 91671999129, 60885589380))
}
