% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spoints.R
\name{spoints}
\alias{spoints}
\alias{spoints.default}
\alias{spoints.data.grid}
\alias{spoints.SpatialPointsDataFrame}
\title{Scatter plot with a color scale}
\usage{
spoints(x, ...)

\method{spoints}{default}(
  x,
  y = NULL,
  s,
  slim = range(s, finite = TRUE),
  col = jet.colors(128),
  breaks = NULL,
  legend = TRUE,
  horizontal = FALSE,
  legend.shrink = 1,
  legend.width = 1.2,
  legend.mar = ifelse(horizontal, 3.1, 5.1),
  legend.lab = NULL,
  bigplot = NULL,
  smallplot = NULL,
  lab.breaks = NULL,
  axis.args = NULL,
  legend.args = NULL,
  add = FALSE,
  reset = TRUE,
  pch = 16,
  cex = 1.5,
  xlab = NULL,
  ylab = NULL,
  asp = NA,
  ...
)

\method{spoints}{data.grid}(x, s = x[[1]], xlab = NULL, ylab = NULL, ...)

\method{spoints}{SpatialPointsDataFrame}(x, data.ind = 1, main, xlab, ylab, legend.lab, ...)
}
\arguments{
\item{x}{object used to select a method. In the default method, it provides the \code{x} 
coordinates for the plot (and optionally the \code{y} coordinates; 
any reasonable way of defining the coordinates is acceptable, 
see the function \code{\link{xy.coords}} for details).}

\item{...}{additional graphical parameters (to be passed to the main plot function
or \code{sxxxx.default}; e.g. \code{xlim, ylim,} ...). NOTE:
graphical arguments passed here will only have impact on the main plot.
To change the graphical defaults for the legend use the \code{\link{par}}
function beforehand (e.g. \code{par(cex.lab = 2)} to increase colorbar labels).}

\item{y}{y coordinates. Alternatively, a single argument \code{x} can be provided.}

\item{s}{numerical vector containing the values used for coloring the points.}

\item{slim}{limits used to set up the color scale.}

\item{col}{color table used to set up the color scale (see \code{\link{image}} for
details).}

\item{breaks}{(optional) numeric vector with the breakpoints for the color scale: 
must have one more breakpoint than \code{col} and be in increasing order.}

\item{legend}{logical; if \code{TRUE} (default), the plotting region is splitted into two parts,
drawing the main plot in one and the legend with the color scale in the other.
If \code{FALSE} only the (coloured) main plot is drawn and the arguments related
to the legend are ignored (\code{\link{splot}} is not called).}

\item{horizontal}{logical; if \code{FALSE} (default) legend will be a vertical strip on the
right side. If \code{TRUE} the legend strip will be along the bottom.}

\item{legend.shrink}{amount to shrink the size of legend relative to the
full height or width of the plot.}

\item{legend.width}{width in characters of the legend strip. Default is
1.2, a little bigger that the width of a character.}

\item{legend.mar}{width in characters of legend margin that has the axis.
Default is 5.1 for a vertical legend and 3.1 for a horizontal legend.}

\item{legend.lab}{label for the axis of the color legend. Default is no
label as this is usual evident from the plot title.}

\item{bigplot}{plot coordinates for main plot. If not passed, and \code{legend}
is TRUE, these will be determined within the function.}

\item{smallplot}{plot coordinates for legend strip. If not passed, and \code{legend}
is TRUE, these will be determined within the function.}

\item{lab.breaks}{if breaks are supplied these are text string labels to
put at each break value. This is intended to label axis on a transformed
scale such as logs.}

\item{axis.args}{additional arguments for the axis function used to create
the legend axis (see \code{\link[fields]{image.plot}} for details).}

\item{legend.args}{arguments for a complete specification of the legend
label. This is in the form of list and is just passed to the \code{\link{mtext}}
function. Usually this will not be needed (see \code{\link[fields]{image.plot}} 
for details).}

\item{add}{logical; if \code{TRUE} the scatter plot is just added 
to the existing plot.}

\item{reset}{logical; if \code{FALSE} the plotting region
(\code{\link{par}("plt")}) will not be reset to make it possible to add more features
to the plot (e.g. using functions such as points or lines). If \code{TRUE} (default) 
the plot parameters will be reset to the values before entering the function.}

\item{pch}{vector of plotting characters or symbols: see \code{\link{points}}.}

\item{cex}{numerical vector giving the amount by which plotting characters
and symbols should be scaled relative to the default. This works as a multiple
of \code{\link{par}("cex")}.}

\item{xlab}{label for the x axis, defaults to a description of \code{x}.}

\item{ylab}{label for the y axis, defaults to a description of \code{y}.}

\item{asp}{the y/x aspect ratio, see \code{\link{plot.window}}.}

\item{data.ind}{integer (or character) with the index (or name) of the data component.}

\item{main}{an overall title for the plot.}
}
\value{
Invisibly returns a list with the following 3 components:
\item{bigplot}{plot coordinates of the main plot. These values may be useful for 
drawing a plot without the legend that is the same size as the plots with legends.}
\item{smallplot}{plot coordinates of the secondary plot (legend strip).}
\item{old.par}{previous graphical parameters (\code{par(old.par)} 
will reset plot parameters to the values before entering the function).}
}
\description{
\code{spoints} (generic function) draws a scatter plot with points filled with different colors
and (optionally) adds a legend strip with the color scale
(calls \code{\link{splot}} and \code{\link{plot.default}}).
}
\details{
\code{spoints.SpatialPointsDataFrame} sets default values for some of the arguments 
from attributes of the object \code{x} (if present; see e.g. \code{precipitation}).
}
\section{Side Effects}{
 After exiting, the plotting region may be changed 
(\code{\link{par}("plt")}) to make it possible to add more features to the plot
(set \code{reset = FALSE} to avoid this).
}

\examples{
with( aquifer, spoints(lon, lat, head, main = "Wolfcamp aquifer data"))
}
\seealso{
\code{\link{splot}}, \code{\link{simage}}, \code{\link{spersp}}, 
\code{\link{image}}, \code{\link[fields]{image.plot}}, \code{\link{data.grid}}, 
\code{\link{plot.default}}.
}
\author{
Based on \code{\link[fields]{image.plot}} function from package \pkg{fields}:
fields, Tools for spatial data.
Copyright 2004-2013, Institute for Mathematics Applied Geosciences.
University Corporation for Atmospheric Research.

Modified by Ruben Fernandez-Casal <rubenfcasal@gmail.com>.
}
\keyword{hplot}
