% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribute_sim_dep.R
\name{attribute_sim_dep}
\alias{attribute_sim_dep}
\title{Simulate the Attributes with the Assumption of Dependent Attributes}
\usage{
attribute_sim_dep(
  product_shapes_and_levels,
  attributes_number,
  shape_attributes_number,
  level_attributes_number
)
}
\arguments{
\item{product_shapes_and_levels}{A numeric dateframe of three columns: product_id, assigned_shape and assigned_level}

\item{attributes_number}{The number of attributes}

\item{shape_attributes_number}{The number of attributes assigned to shape}

\item{level_attributes_number}{The number of attributes assigned to level}
}
\value{
A numeric dateframe of the following columns: product_id, assigned_shape, assigned_level and attributes (as columns)
}
\description{
Simulate the attributes for each product with the assumption
that some of the attributes related to shapes are also related to some
of the attributes of levels.
We mean by dependence the fact that some attributes of a product are related
at the same time to its shape and level.
}
\examples{
attribute_sim_dep(product_shapes_and_levels=
data.frame(product_id=1:4,assigned_shape=c(1,1,2,2),
assigned_level=c(5,3,3,3)),
attributes_number=15,
shape_attributes_number=7,
level_attributes_number=4)

}
