% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transparent.R
\name{Check_IV_ineqs}
\alias{Check_IV_ineqs}
\title{Check of the Instrumental Variable (IV) inequalities.}
\usage{
Check_IV_ineqs(n_y0x0z0, n_y1x0z0 = NA, n_y0x1z0 = NA, n_y1x1z0 = NA,
  n_y0x0z1 = NA, n_y1x0z1 = NA, n_y0x1z1 = NA, n_y1x1z1 = NA,
  verbose = FALSE)
}
\arguments{
\item{n_y0x0z0}{Number of individuals with Y=0, X=0, Z=0.
Alternatively, a vector with elements
(either counts, p(y, x , z) or p(y, x | z)) in the order of the arguments.}

\item{n_y1x0z0}{Number of individuals with Y=1, X=0, Z=0.}

\item{n_y0x1z0}{Number of individuals with Y=0, X=1, Z=0.}

\item{n_y1x1z0}{Number of individuals with Y=1, X=1, Z=0.}

\item{n_y0x0z1}{Number of individuals with Y=0, X=0, Z=1.}

\item{n_y1x0z1}{Number of individuals with Y=1, X=0, Z=1.}

\item{n_y0x1z1}{Number of individuals with Y=0, X=1, Z=1.}

\item{n_y1x1z1}{Number of individuals with Y=1, X=1, Z=1.}

\item{verbose}{Whether to return all the IV inequalities (TRUE)
or just a check that the inequalities have been satisfied empirically.}
}
\value{
A list of all the IV inequalities or a check of whether all
   the inequalities have been satisfied empirically.
}
\description{
This checks whether the Instrumental Variable (IV) inequalities
   for a binary dataset have been \emph{satisfied} empirically,
   assuming only Randomization and Exclusion Restriction for the
   principal strata of Always Takers and Never Takers.
   Monotonicity (no Defiers) is \emph{not} assumed here.
}
\examples{
Check_IV_ineqs(158, 14, 0, 0, 52, 12, 23, 78)
Check_IV_ineqs(c(158, 14, 0, 0, 52, 12, 23, 78))
Check_IV_ineqs(158, 14, 0, 0, 52, 12, 23, 78, TRUE)
Check_IV_ineqs(99, 1027, 30, 233, 84, 935, 31, 422)
Check_IV_ineqs(c(99, 1027, 30, 233, 84, 935, 31, 422))
Check_IV_ineqs(99, 1027, 30, 233, 84, 935, 31, 422, TRUE)
}
\references{
{A. Balke and J. Pearl. (1997).
   Bounds on treatment effects from studies with imperfect compliance.
   \emph{Journal of the American Statistical Association, 1171-1176}.},

{B. Bonet. (2001).
   Instrumentality tests revisited.
   \emph{In Proceedings of the Seventeenth Conference on Uncertainty in
   Artificial Intelligence, 48-55}.}
}

