% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/070_unc_vgau_an.R
\name{unc_vgau_an}
\alias{unc_vgau_an}
\alias{unc_vgau_an.default}
\alias{unc_vgau_an.formula}
\title{Unconditional vp-Gaussian attribute noise}
\usage{
\method{unc_vgau_an}{default}(x, y, level, sortid = TRUE, ...)

\method{unc_vgau_an}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per attribute.}
\item{idnoise}{an integer vector list with the indices of noisy samples per attribute.}
\item{numclean}{an integer vector with the amount of clean samples per attribute.}
\item{idclean}{an integer vector list with the indices of clean samples per attribute.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Unconditional vp-Gaussian attribute noise} into a classification dataset.
}
\details{
In \emph{Unconditional vp-Gaussian attribute noise}, the noise level for numeric attributes indicates 
the magnitude of the errors introduced. For each attribute \emph{A}, all the original values are corrupted 
by adding a random number that follows a Gaussian distribution with \emph{mean} = 0 and 
\emph{variance} = \code{level}\%
of the variance of \emph{A}. For nominal attributes, (\code{level}·100)\% of the samples in the dataset 
are chosen and a random value is selected as noisy.
}
\note{
Noise model adapted from the papers in References, corrupting all samples and 
allowing nominal attributes.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- unc_vgau_an(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- unc_vgau_an(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
X. Huang, L. Shi, and J. A. K. Suykens. 
\strong{Support vector machine classifier with pinball loss}. 
\emph{IEEE Transactions on Pattern Analysis and Machine Intelligence}, 36(5):984-997, 2014.
\doi{10.1109/TPAMI.2013.178}.
}
\seealso{
\code{\link{symd_rpix_an}}, \code{\link{unc_fixw_an}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
