% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_screening.R
\name{ptmvn_check_converge}
\alias{ptmvn_check_converge}
\title{Check the convergence of 1st moment with m at selected indices of a PTMVN distribution with zero mean}
\usage{
ptmvn_check_converge(
  y,
  cens_lb,
  cens_ub,
  covmat = NULL,
  locs = NULL,
  cov_name = NULL,
  cov_parm = NULL,
  m_vec = seq(from = 10, to = 100, by = 10),
  N = 1000,
  ind_test = NULL
)
}
\arguments{
\item{y}{responses before censoring, of length n}

\item{cens_lb}{\code{cens_lb} and \code{cens_ub} define the censoring region, of length n}

\item{cens_ub}{\code{cens_lb} and \code{cens_ub} define the censoring region, of length n}

\item{covmat}{n-by-n dense covariance matrix, either \code{covmat} or \code{locs},
\code{cov_name}, and \code{cov_parm} need to be provided}

\item{locs}{location matrix n X d}

\item{cov_name}{covariance function name from the \code{GpGp} package}

\item{cov_parm}{parameters for the covariance function from the \code{GpGp} package}

\item{m_vec}{a vector of \code{m} values (int) to be tested}

\item{N}{the number of samples to generate for each test index and each \code{m} to evaluate 1st-order moment}

\item{ind_test}{a vector of indices indexing the locs where we check the 1st-order moment convergence, by default, 10 random indices are used. If some test loc is not censored, the function treats it as unobserved}
}
\value{
a matrix summarizing the 1st moments evaluated at increasing m at the selected indices
}
\description{
Check the convergence of 1st moment with m at selected indices of a PTMVN distribution with zero mean
}
\examples{
library(GpGp)
library(nntmvn)
library(lhs)
library(ggplot2)
set.seed(123)
n <- 500
locs <- lhs::randomLHS(n, 2)
lb <- rep(-Inf, n)
ub <- rep(0, n)
covmat <- GpGp::matern15_isotropic(c(1, 0.1, 0.01), locs)
y <- as.vector(t(chol(covmat)) \%*\% rnorm(n))
check_obj <- ptmvn_check_converge(y, lb , ub, covmat,
                                  m_vec = seq(from = 10, to = 50, by = 10)
)
first_mmt <- check_obj$pred
plot(first_mmt)
pred_err <- check_obj$error
plot(pred_err)
}
