% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNTCalculation.R
\name{RMvsKM}
\alias{RMvsKM}
\title{Compare the performance between the NNT-RMST and NNT-KM through
  the average life gain per patient}
\usage{
RMvsKM(time, status, arm, tau = NULL, confint = 0.95, digits = 3)
}
\arguments{
\item{time}{The time to event or censor.}

\item{status}{The indicator of the event or censor at the end of the follow-up.}

\item{arm}{The variable indicates the treatment (arm = 1) and control (arm = 0) groups.}

\item{tau}{The chosen time point of clinical interest.}

\item{confint}{The percentile of confidence interval. The default value is
\code{confint = 0.95}.}

\item{digits}{The decimal of the results. The default value is \code{digits = 3}.}
}
\value{
A list contains:

\item{RMSTNNT}{The RMST-NNT and its confidence interval.}

\item{KMNNT}{The KM-NNT and its confidence interval.}

\item{LifeGain}{The average life gain per patient based on the RMST-NNT and KM-NNT.}
}
\description{
For the NNT-RMST, the average life gain per patient is the area
between the survival curves, which is the instrinsic treatment
 benefit in survival time during the t-period follow-up. For the NNT-KM, the
 average life gain per patient is defined as the ratio between the average
 survival time of one death in patients and the NNT-KM up to t.
}
\examples{
library(survival)
dat <- pbc[!is.na(pbc$trt),]
time <- dat$time/365.25
status <- (dat$status == 2) + 0
arm <- (dat$trt == 2) + 0
RMvsKM(time, status, arm, tau = NULL, confint = 0.95, digits = 3)

}
\references{
1. An alternative approach for estimating the number needed to treat for survival endpoints.
 PLoS One. 2019 Oct 18;14(10):e0223301. doi: 10.1371/journal.pone.0223301.
}
