% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsic.R
\name{uplo2uco}
\alias{uplo2uco}
\title{Transform box-type inequalities into matrix and vector form}
\usage{
uplo2uco(param, upper = NULL, lower = NULL, linear = NULL)
}
\arguments{
\item{param}{a named vector whose names will be used for parsing inequalities}

\item{upper}{a named numeric vector of upper limits}

\item{lower}{a named numeric vector of lower limits}

\item{linear}{a string vector of linear inequalities}
}
\value{
a list with numeric matrix 'u' and vector 'co' such that \code{u\%*\%param-co>=0}
}
\description{
Transform a set of inequalities  \code{param["name"] >= lower["name"]} and
\code{param["name"] <= upper["name"]} into a list with matrix u and vector co such that
u\%*\%param>=co. In addition to box inequalities above, user can provide linear
inequalities in a form like \code{"a+2*c+3*b >= 0"} where 'a', 'b' and 'c' must be names of
param components. Numeric and symbolic coefficients and right hand sides
are allowed in these expressions. However, symbols must be defined at the moment
of calling \code{uplo2uco()} so that expressions containing such symbols could
be \code{eval()}-ed to numerical values. All inequalities must be written with '>='
sign (not with '<=', '>', ...).
}
\seealso{
\link{equa2vecmat} for parsing linear expressions
}
