% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_single_point_base.R
\name{trimmed_geom_mean}
\alias{trimmed_geom_mean}
\title{Computes the trimmed geometric mean}
\usage{
trimmed_geom_mean(x, trim = 0, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector containing the values for geometric mean
calculation.}

\item{trim}{A numeric value between 0 and 0.5 indicating the proportion of
values to be trimmed from each end of the vector. Default is 0.}

\item{na.rm}{Logical value indicating whether missing values should be
removed before computation. Default is TRUE.}
}
\value{
A numeric value representing the trimmed geometric mean. Returns NA if no
values remain after trimming.
}
\description{
Computes the trimmed geometric mean of a numeric vector
}
\examples{
x <- c(1, 2, 3, 4, 5, 100)
trimmed_geom_mean(x, trim = 0.05)

}
