% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zbeta_gaussian.R
\name{zbeta_gaussian}
\alias{zbeta_gaussian}
\title{Posterior samples of spatial effects and intercept for the squared
exponential kernel}
\usage{
zbeta_gaussian(y, dists, phi, sigma2, tau2)
}
\arguments{
\item{y}{response}

\item{dists}{distance matrix derived from coordinates}

\item{phi}{posterior samples of \eqn{\phi}}

\item{sigma2}{posterior samples of \eqn{\sigma^2}}

\item{tau2}{posterior samples of \eqn{\tau^2}}
}
\value{
A matrix of spatial effects and intercept. For internal use only.
}
\description{
For internal use only.
}
\examples{
\dontrun{
#####################
# Internal use only #
#####################
# Example usage inside of nimblewomble::zbeta_samples(...)
zbG = compileNimble(zbeta_gaussian)
zb.samples = zbG(y = y, dists = dists, phi = phi, sigma2 = sigma2,
                 tau2 = tau2)
}
}
\author{
Aritra Halder <aritra.halder@drexel.edu>, \cr
Sudipto Banerjee <sudipto@ucla.edu>
}
\keyword{zbeta_gaussian}
