% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwish.R
\name{rwish}
\alias{rwish}
\title{Random draws from a Wishart (or Inverse-Wishart) distribution.}
\usage{
rwish(n, Psi, nu, inv = FALSE)
}
\arguments{
\item{n}{Number of samples to draw.}

\item{Psi}{Scale matrix.}

\item{nu}{Degrees of freedom.}

\item{inv}{Logical. Setting \code{inv = TRUE} returns random matrices from an Inverse-Wishart distribution. See 'Details'.}
}
\value{
Returns an array of Wishart (or Inverse-Wishart) draws of size \code{c(nrow(Psi),ncol(Psi),n)}.
}
\description{
Generates a random samples from a Wishart distribution defined as \eqn{W(\Psi, \nu)}, or an Inverse-Wishart distribution defined as \eqn{W^{-1}(\Psi, \nu)}.
}
\details{
Setting \code{inv = TRUE} replaces \eqn{\Psi} by \eqn{Psi^{-1}} and inverts the output random matrices, such that they are being generated from an Inverse-Wishart \eqn{W^{-1}(\Psi, \nu)} distribution.
}
\examples{
d <- 4 # number of dimensions
nu <- 7 # degrees of freedom
Psi <- crossprod(matrix(rnorm(d^2), d, d)) # scale matrix
n <- 1e4

Sigma <- rwish(n, Psi, nu)

# for any vector a, X = (a' Sigma a) has a const * chi^2 distribution
a <- rnorm(d)
X <- apply(Sigma, 3, function(S) crossprod(a, S \%*\% a))
const <- c(a \%*\% Psi \%*\% a)

hist(X, breaks = 100, freq = FALSE,
     main = parse(text = "\"Histogram of \"*X==a*minute*Sigma*a"),
     xlab = parse(text = "X==a*minute*Sigma*a"))
curve(dchisq(x/const, df = nu)/const,
      from = min(X), to = max(X), col = "red", add = TRUE)
}
\seealso{
\code{\link[=rniw]{rniw()}}
}
