% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_ref.R
\name{impute_ref}
\alias{impute_ref}
\title{Multiple Imputation for NIAID-OS using a reference.}
\usage{
impute_ref(
  wide,
  m,
  ref = NULL,
  by = NULL,
  days = paste0("D", 1:28),
  bin = rep(1, length(days) - 1),
  Em = get_emission(wide, days),
  listFormatOut = FALSE,
  tol = 1e-06,
  maxiter = 200,
  silent = FALSE
)
}
\arguments{
\item{wide}{Data in wide format (i.e., each day is a column).}

\item{m}{Number of imputations.}

\item{ref}{Character vector with 1 column names. Specifies the reference group column. The reference group column must be logical, and there must be some (>=15) members of the reference group in each strata.}

\item{by}{Character vector with column names. Data will be broken up and imputed separately for every combination of values for specified columns in the data.}

\item{days}{Names of the columns that contain the score for each day. Columns should be in sequential order.}

\item{bin}{The assigned bin for pooling together information across transitions. Must be a numeric vector of length=(length(days)-1). By default all transitions are pooled together.}

\item{Em}{Emission probabilities. Generally the default should not be changed.}

\item{listFormatOut}{Return each imputed dataset in a list or combine into a single dataset.}

\item{tol}{Tolerance for relative reduction the log-likelihood to determine convergence of the Baum-Welch algorithm.}

\item{maxiter}{Maximum iterations before stopping the EM algorithm.}

\item{silent}{Allows silencing some messages.}
}
\value{
If listFormatOut = TRUE, then a list will be returned with each element being an imputed data set.
If listFormatOut = FALSE, then a single data.frame will be returned where IMP_ID column is created.
}
\description{
Imputes NIAID OS data using a Markov model.
}
\details{
States for each patient/day in 'wide' may be the following: 
\itemize{
 \item{Not missing:}{An integer from 1 to 8.}
 \item{Missing:}{NA}
 \item{Partially Missing:}{ Range which may be code as a characters string such as '[1,7]' or '[1,2]'. Such a character string indicates that while the actual value is unknown, it is known that the value falls within the specified range. }
}
The reference based imputation uses a simple modification to the standard procedure.
First, within each strata, the model fit and bootstrapping procedure is performed only using the patients that are 
in the reference group. Second, the imputation for all of the patients in that strata (both reference and treated patients) 
is performed using the parameters as estimated/simulated based on the patients in the reference group.
}
\examples{
test <- sim_data(300)
test$PBO=sample(c(TRUE, FALSE), size=nrow(test), replace = TRUE)
bs <- impute_ref(wide=test,ref="PBO",m=2, by="strata", silent=TRUE)
}
\seealso{
\code{\link{bootstrap_param_est}}
}
