% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vztdraw_sc_step_regular_cpp.R
\name{vztdraw_sc_step_regular_cpp}
\alias{vztdraw_sc_step_regular_cpp}
\title{Vectorized sampling from zero-truncated NHPPPs with piecewise constant intensities
with same interval lengths}
\usage{
vztdraw_sc_step_regular_cpp(
  lambda_matrix = NULL,
  Lambda_matrix = NULL,
  rate_matrix_t_min = NULL,
  rate_matrix_t_max = NULL,
  t_min = NULL,
  t_max = NULL,
  atmost1 = FALSE
)
}
\arguments{
\item{lambda_matrix}{(matrix) intensity rates, one per interval}

\item{Lambda_matrix}{(matrix) integrated intensity rates at the end of each interval}

\item{rate_matrix_t_min}{(scalar | vector | column matrix) is the lower bound
of the time interval for each row of (Lambda|lambda)_maj_matrix.
The length of this argument is the number of point processes that should be drawn.}

\item{rate_matrix_t_max}{(scalar | vector | column matrix) the upper bound
of the time interval for each row of (Lambda|lambda)_maj_matrix.
The length of this argument is the number of point processes that should be drawn.}

\item{t_min}{(scalar | vector | column matrix) is the lower bound
of a subinterval of (rate_matrix_t_min, rate_matrix_t_max]. If set,
times are sampled from the subinterval.
If omitted, it is equivalent to \code{rate_matrix_t_min}.}

\item{t_max}{(scalar | vector | column matrix) is the upper bound
of a subinterval of (rate_matrix_t_min, rate_matrix_t_max]. If set,
times are sampled from the subinterval.
If omitted, it is equivalent to \code{rate_matrix_t_max}.}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times t
if no events realize, it will have 0 length
}
\description{
Simulate a piecewise constant-rate Poisson Point Process over \verb{(t_min, t_max]} (inversion method)
where the intervals have the same length (are "regular").
}
\keyword{internal}
