% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwd.R
\name{bwd}
\alias{bwd}
\alias{dbwd}
\alias{pbwd}
\alias{qbwd}
\alias{rbwd}
\title{Bimodal Weibull Distribution}
\usage{
dbwd(x, alpha, beta = 1, sigma, log = FALSE)

pbwd(q, alpha, beta = 1, sigma, lower.tail = TRUE, log.p = FALSE)

qbwd(p, alpha, beta = 1, sigma, lower.tail = TRUE)

rbwd(n, alpha, beta = 1, sigma)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha}{a shape parameter.}

\item{beta}{a scale parameter.}

\item{sigma}{a control parameter that controls the uni- or bimodality of the
distribution.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dbwd} gives the density, \code{pbwd} gives the distribution
function, \code{qbwd} gives the quantile function and \code{rbwd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
a Bimodal Weibull distribution with parameters \code{shape} and \code{scale}.
}
\details{
A Bimodal Weibull distribution with \code{shape} parameter \eqn{\alpha},
\code{scale} parameter \eqn{\beta},and the \code{control} parameter
\eqn{\sigma} that determines the uni- or bimodality of the
distribution, has density
\deqn{f\left( x\right) =\frac{\alpha }{\beta Z_{\theta }}
\left[ 1+\left( 1-\sigma~x\right) ^{2}\right] \left( \frac{x}{\beta }
\right) ^{\alpha -1}\exp \left( -\left( \frac{x}{\beta }\right) ^{\alpha }
\right),}
where
\deqn{Z_{\theta }=2+\sigma ^{2}\beta ^{2}\Gamma
\left( 1+\left( 2/\alpha \right)\right) -2\sigma \beta \Gamma
\left( 1+\left( 1/\alpha \right) \right) }
and
\deqn{x\geq 0,~\alpha ,\beta >0~ and ~\sigma \in\mathbb{R}.}
}
\examples{
library(new.dist)
dbwd(1,alpha=2,beta=3,sigma=4)
pbwd(1,alpha=2,beta=3,sigma=4)
qbwd(.7,alpha=2,beta=3,sigma=4)
rbwd(10,alpha=2,beta=3,sigma=4)
}
\references{
Vila, R. ve Niyazi Çankaya, M., 2022,
\emph{A bimodal Weibull distribution: properties and inference},
Journal of Applied Statistics, 49 (12), 3044-3062.
}
