\name{calculate_all_mse_neutrosophic}
\alias{calculate_all_mse_neutrosophic}
\title{Calculate All MSE Neutrosophic}
\usage{
calculate_all_mse_neutrosophic(
  theta_L,
  theta_U,
  Y_L,
  Y_U,
  X_L,
  X_U,
  Cx_L,
  Cx_U,
  Cy_L,
  Cy_U,
  rho_L,
  rho_U,
  B_L,
  B_U
)
}
\arguments{
\item{theta_L}{Lower theta value (1/n_L - 1/N_L)}

\item{theta_U}{Upper theta value (1/n_U - 1/N_U)}

\item{Y_L}{Lower study mean}

\item{Y_U}{Upper study mean}

\item{X_L}{Lower auxiliary mean}

\item{X_U}{Upper auxiliary mean}

\item{Cx_L}{Lower auxiliary CV}

\item{Cx_U}{Upper auxiliary CV}

\item{Cy_L}{Lower study CV}

\item{Cy_U}{Upper study CV}

\item{rho_L}{Lower correlation}

\item{rho_U}{Upper correlation}

\item{B_L}{Lower kurtosis}

\item{B_U}{Upper kurtosis}
}
\value{
A list containing five types of MSE estimates:
\itemize{
  \item MSE - Standard MSE estimates (Lower, Upper)
  \item MSE1 - Ratio-adjusted MSE estimates
  \item MSE2 - Kurtosis-adjusted MSE estimates
  \item MSE_exp - Exponential MSE estimates
  \item MSE_r - Regression MSE estimates
}
}
\author{
Neha Purwar, Kaustav Aditya, Pankaj Das and Bharti
}

\description{
Computes various Mean Squared Error (MSE) estimates for neutrosophic interval data
using different adjustment methods.
}
\examples{
# First compute metrics from data
data(japan_neutro)
metrics <- compute_all_metrics(japan_neutro)

# Define population parameters (non-interactive example)
inputs <- list(theta_L = 0.01, theta_U = 0.02)

# Calculate all MSE types
mse_results <- calculate_all_mse_neutrosophic(
  inputs$theta_L, inputs$theta_U,
  metrics$mean_interval_Y[1], metrics$mean_interval_Y[2],
  metrics$mean_interval_X[1], metrics$mean_interval_X[2],
  metrics$cv_interval_X[1], metrics$cv_interval_X[2],
  metrics$cv_interval_Y[1], metrics$cv_interval_Y[2],
  metrics$correlation_results[1], metrics$correlation_results[2],
  metrics$kurtosis_interval_X[1], metrics$kurtosis_interval_X[2]
)

# Print results
print(mse_results)
}
