% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/index_vol.R, R/neuro_obj.R,
%   R/neurospace.R
\name{space}
\alias{space}
\alias{space,IndexLookupVol-method}
\alias{space,ROICoords-method}
\alias{space,NeuroObj-method}
\alias{space,NeuroSpace-method}
\title{Extract Geometric Properties of an Image}
\usage{
space(x, ...)

\S4method{space}{IndexLookupVol}(x)

\S4method{space}{ROICoords}(x)

\S4method{space}{NeuroObj}(x)

\S4method{space}{NeuroSpace}(x)
}
\arguments{
\item{x}{An \code{\linkS4class{IndexLookupVol}} object}

\item{...}{Additional arguments, if needed.}
}
\value{
A \code{\linkS4class{NeuroSpace}} object representing the geometric space of \code{x}.
}
\description{
This function retrieves the geometric properties of a given image, such as dimensions and voxel size.

Retrieves the NeuroSpace object associated with an IndexLookupVol object.
}
\examples{
# Create a NeuroSpace object with dimensions (10, 10, 10) and voxel size (1, 1, 1)
x <- NeuroSpace(c(10, 10, 10), c(1, 1, 1))

# Create a NeuroVol object with random data and the specified NeuroSpace
vol <- NeuroVol(rnorm(10 * 10 * 10), x)

# Retrieve the geometric properties of the NeuroVol object
identical(x, space(vol))

space <- NeuroSpace(c(64, 64, 64), c(1, 1, 1), c(0, 0, 0))
ilv <- IndexLookupVol(space, c(1:100))
space(ilv)  # Get the associated NeuroSpace object


}
