% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_io.R
\name{BinaryWriter}
\alias{BinaryWriter}
\title{Create Binary Writer Object}
\usage{
BinaryWriter(
  output,
  byte_offset,
  data_type,
  bytes_per_element,
  endian = .Platform$endian
)
}
\arguments{
\item{output}{Character string (file name) or connection object to write to}

\item{byte_offset}{Integer specifying bytes to skip at start of output}

\item{data_type}{Character string specifying R data type ('integer', 'double', etc.)}

\item{bytes_per_element}{Integer specifying bytes per data element (e.g., 4 or 8)}

\item{endian}{Character string specifying endianness ('big' or 'little', default: platform-specific)}
}
\value{
An object of class \linkS4class{BinaryWriter}
}
\description{
Create a new instance of the \linkS4class{BinaryWriter} class for writing bulk binary data.
}
\examples{
\donttest{

tmp <- tempfile()
# Write to existing connection with offset
con <- file(tmp, "wb")
writer <- BinaryWriter(con, byte_offset = 100L,
                      data_type = "integer", bytes_per_element = 4L)
unlink(tmp)
}
}
\seealso{
\code{\link{BinaryReader}} for reading binary data
}
