% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-auth.R
\name{ns_get_token}
\alias{ns_get_token}
\title{Get Current Nettskjema Access Token}
\usage{
ns_get_token(
  client_id = Sys.getenv("NETTSKJEMA_CLIENT_ID"),
  client_secret = Sys.getenv("NETTSKJEMA_CLIENT_SECRET"),
  client_name = "nettskjemar"
)
}
\arguments{
\item{client_id}{Character. Retrieved from the
Client portal.}

\item{client_secret}{Character. Retrieved from the
Client portal.}

\item{client_name}{Character. Used to identify who
has been running the commands.}
}
\value{
httr2 token object, list with
   access_token, token_type, and expires_in
}
\description{
Retrieves the current OAuth2 access token for debugging
purposes, such as testing endpoints in Swagger UI.
This function uses the client credentials flow to obtain
the token.
You will not normally need to call this function
directly, as authentication is handled automatically.
}
\examples{
\dontrun{
# Get token for Swagger debugging
token <- ns_get_token()
token$access_token
}
}
