% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-data_labels.R
\name{ns_add_labels}
\alias{ns_add_labels}
\title{Add Labels to Dataset}
\usage{
ns_add_labels(data, codebook)
}
\arguments{
\item{data}{data from \code{ns_get_data}}

\item{codebook}{object from
\code{ns_get_codebook}}
}
\value{
A data frame with the same
  structure as `data`, but with
  variable and value labels applied.
  The resulting object is assigned
  the class `"ns-data"`.
}
\description{
The `ns_add_labels` function applies
 labels to variables in a dataset
based on a provided codebook. It
 assigns variable labels, value
labels,
and metadata required for the
"ns-data" class.
}
\examples{
\dontshow{
vcr::insert_example_cassette("ns_add_labels", package = "nettskjemar")
nettskjemar:::mock_if_no_auth()
}
data <- ns_get_data(123823)
cb <- ns_get_codebook(123823)
labeled_data <- ns_add_labels(data, cb)
\dontshow{
vcr::eject_cassette()
}

}
