% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{sample_dcpp}
\alias{sample_dcpp}
\title{Sample from a DCPP}
\usage{
sample_dcpp(
  n,
  lambda,
  K,
  oir,
  theta = NULL,
  pri = rep(1, K)/K,
  normalize_theta = FALSE
)
}
\arguments{
\item{n}{number of nodes}

\item{lambda}{average degree}

\item{K}{number of communities}

\item{oir}{out-in ratio}

\item{theta}{propensity parameter, if not given will be samples from a Pareto
distribution with scale parameter 2/3 and shape parameter 3}

\item{pri}{prior distribution of node labels}

\item{normalize_theta}{whether to normalize theta so that max(theta) == 1}
}
\value{
an adjacency matrix following a degree-corrected planted parition model
}
\description{
Sample from a degree-corrected planted partition model
}
\seealso{
\link{sample_dcsbm}, \link{sample_tdcsbm}
}
