% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nca.check.obs.R
\name{nca.check.obs}
\alias{nca.check.obs}
\title{Check observed data}
\usage{
nca.check.obs(
  obsData,
  idNmObs = "ID",
  timeNmObs = "TIME",
  concNmObs = "DV",
  doseType = "ns",
  doseTime = NULL,
  Tau = NULL,
  filterNm = NULL,
  filterExcl = NULL,
  str1Nm = NULL,
  str1 = NULL,
  str2Nm = NULL,
  str2 = NULL,
  str3Nm = NULL,
  str3 = NULL,
  AUCTimeRange = NULL,
  LambdaTimeRange = NULL,
  adminType = "extravascular",
  TI = NULL,
  doseAmtNm = NULL,
  dateColNm = NULL,
  dateFormat = NULL,
  timeFormat = "number",
  concUnit = NULL,
  timeUnit = NULL,
  doseUnit = NULL,
  blqNm = NULL,
  blqExcl = 1,
  evid = TRUE,
  evidIncl = 0,
  mdv = FALSE
)
}
\arguments{
\item{obsData}{Observed concentration-time data.}

\item{idNmObs}{Column name for ID in observed data. Default is \strong{"ID"}}

\item{timeNmObs}{Column name for time in observed data. Default is 
\strong{"TIME"}}

\item{concNmObs}{Column name for concentration in observed data. Default is 
\strong{"DV"}}

\item{doseType}{Steady-state (ss) or non-steady-state (ns) dose. Default is 
\strong{"ns"}}

\item{doseTime}{Dose time prior to the first observation for steady-state
data. Default is \strong{\code{NULL}}}

\item{Tau}{Dosing interval for steady-state data. Default is
\strong{\code{NULL}}}

\item{filterNm}{Column name to filter data. Default is \strong{\code{NULL}}}

\item{filterExcl}{Row exclusion criteria based on the column defined by
\code{filterNm}. This can be numeric value or logical condition (e.g. c(1,
2, "<20", ">=100", "!=100")). Default is \strong{\code{NULL}}}

\item{str1Nm}{Column name for 1st level population stratifier. Default is
\strong{\code{NULL}}}

\item{str1}{Stratification ID of the members within 1st level stratification
(e.g c(1,2)). Default is \strong{\code{NULL}}}

\item{str2Nm}{Column name for 2nd level population stratifier. Default is
\strong{\code{NULL}}}

\item{str2}{Stratification ID of the members within 2nd level stratification
(e.g c(1,2)). Default is \strong{\code{NULL}}}

\item{str3Nm}{Column name for 3rd level population stratifier. Default is
\strong{\code{NULL}}}

\item{str3}{Stratification ID of the members within 3rd level stratification
(e.g c(1,2)). Default is \strong{\code{NULL}}}

\item{AUCTimeRange}{User-defined window of time used to estimate AUC. Default
is \strong{\code{NULL}}}

\item{LambdaTimeRange}{User-defined window of time to estimate elimination
rate-constant. This argument lets the user to choose a specific window of
time to be used to estimate the elimination rate constant (Lambda) in the
elimination phase. The accepted format for the input to this argument is a
numeric array of two elements; \code{c(14,24)} will estimate the Lambda
using the data within the time units 14 to 24. Default is
\strong{\code{NULL}}}

\item{adminType}{Route of administration. Allowed options are iv-bolus,
iv-infusion or extravascular. Default is \strong{"extravascular"}}

\item{TI}{Infusion duration. If TI is a single numeric value, TI is the same
for all individuals. If TI is the name of a column with numeric data
present in the data set, TI is set to the unique value of the column for a
given individual. Default is \strong{\code{NULL}}}

\item{doseAmtNm}{Column name to specify dose amount. Default is
\strong{\code{NULL}}}

\item{dateColNm}{column name for date if used (e.g. "Date", "DATE"). Default
is \strong{\code{NULL}}}

\item{dateFormat}{date format (D-M-Y, D/M/Y or any other combination of
D,M,Y). Default is \strong{\code{NULL}}}

\item{timeFormat}{time format (number, H:M, H:M:S). Default is
\strong{"number"}}

\item{concUnit}{Unit of concentration (e.g. "ng/mL"). Default is 
\strong{\code{NULL}}}

\item{timeUnit}{Unit of time (e.g. "h"). Default is \strong{\code{NULL}}}

\item{doseUnit}{Unit of dose amount (e.g. "ng"). Default is
\strong{\code{NULL}}}

\item{blqNm}{Name of BLQ column if used to exclude data. Default is
\strong{\code{NULL}}}

\item{blqExcl}{Excluded BLQ value; either a numeric value or a logical
condition (e.g. 1 or ">=1" or c(1,">3")). Used only if the \code{blqNm} is
not \code{NULL}. Default is \strong{"1"}}

\item{evid}{If \code{TRUE} EVID is used to filter data. Default is
\strong{\code{TRUE}}}

\item{evidIncl}{Included values in EVID. Default is \strong{"0"}}

\item{mdv}{If \code{TRUE} MDV is used to include data when MDV=0. Default is
\strong{\code{FALSE}}}
}
\value{
A list of objects
}
\description{
\pkg{nca.check.obs} Checks observed data for compatibility with ncappc and
processes the data with various filtering criteria.
}
\details{
\pkg{nca.check.obs} Checks observed data for compatibility with ncappc.
}
