% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_validation.R
\name{internalCheckNBC}
\alias{internalCheckNBC}
\title{Check arguments for nbc()}
\usage{
internalCheckNBC(train, test, known = TRUE, assume = FALSE, unknown = 99)
}
\arguments{
\item{train}{Dataframe of verbal autopsy train data (See \href{https://rrwen.github.io/nbc4va/data}{Data documentation}).
\itemize{
  \item Columns (in order): ID, Cause, Symptom-1 to Symptom-n..
  \item ID (vectorof char): unique case identifiers
  \item Cause (vectorof char): observed causes for each case
  \item Symptom-n.. (vectorsof (1 OR 0)): 1 for presence, 0 for absence, other values are treated as unknown
  \item Unknown symptoms are imputed randomly from distributions of 1s and 0s per symptom column; if no 1s or 0s exist then the column is removed
}
Example:
\tabular{ccccc}{
  ID \tab Cause \tab S1 \tab S2 \tab S3 \cr
  "a1" \tab "HIV" \tab 1 \tab 0 \tab 0\cr
  "b2" \tab "Stroke" \tab 0 \tab 0 \tab 1\cr
  "c3" \tab "HIV" \tab 1 \tab 1 \tab 0
}}

\item{test}{Dataframe of verbal autopsy test data in the same format as \emph{train} except if causes are not known:
\itemize{
  \item The 2nd column (Cause) can be omitted if \emph{known} is FALSE
}}

\item{known}{TRUE to indicate that the \emph{test} causes are available in the 2nd column and FALSE to indicate that they are not known}

\item{assume}{TRUE to set all symptoms not equal to 1 as 0 and FALSE to raise error if symptoms are not 0 or 1. This takes priority over \emph{unknown}.}

\item{unknown}{A single integer value which determines if a symptom is unknown as to if is present or absent.
\itemize{
  \item The unknown values are substituted according to the proportion of the 1s and 0s per column
  \item Setting this to NULL will ignore this substitution
  \item All other values that are not the unknown value or 1 will be set to 0 after the substition
}}
}
\value{
out A list object containing the checked inputs:
\itemize{
  \item $train: dataframe of id, cause and symptoms
  \item $test: dataframe of id, cause and symptoms in the same format as \emph{train}
  \item $known: TRUE if the \emph{test} causes are known or FALSE if not
}
}
\description{
Performs checks to ensure that the arguments passed to \code{\link{internalNBC}} are correct.
This function will also auto-clean when appropriate, and display
warning messages of the cleaning tasks.
}
\details{
The following checks are applied to \emph{train} and \emph{test} to ensure they:
\itemize{
  \item are a dataframe
  \item have required number of rows and columns
  \item have required data types for each column
  \item have required symptom values
  \item are in the same format
  \item have unique ids
}
}
\examples{
library(nbc4va)
data(nbc4vaData)

# Check train and test inputs, error if it does not pass check
train <- nbc4vaData[1:50, ]
test <- nbc4vaData[51:100, ]
checked <- nbc4va::internalCheckNBC(train, test)
train <- checked$train
test <- checked$test

}
\seealso{
Other validation functions: 
\code{\link{internalCheckNBCSummary}()}
}
\concept{validation functions}
\keyword{internal}
