% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{mc_info}
\alias{mc_info}
\title{Get sensors info table}
\usage{
mc_info(data)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}
}
\value{
data.frame with columns:
\itemize{
\item locality_id - when provided by user then locality ID, when not provided identical with serial number
\item serial_number - serial number of logger when provided or automatically detected from file name or header
\item sensor_id - original sensor id (e.g.,"GDD", "HOBO_T" ,"TMS_T1", "TMS_T2")
\item sensor_name - original sensor id if not modified, if renamed then new name (e.g.,"GDD5", "HOBO_T_mean" ,"TMS_T1_max", "my_sensor01")
\item start_date - the oldest record on the sensor
\item end_date - the newest record on the sensor
\item step_seconds - time step of records series (seconds)
\item period - time step of records series (text)
\item min_value - minimal recorded values
\item max_value - maximal recorded value
\item count_values - number of non NA records
\item count_na - number of NA records
\item height - height description of sensor
\item calibrated - logical value indicating whether the sensor is calibrated
}
}
\description{
This function return data.frame with info about sensors
}
\examples{
mc_info(mc_data_example_agg)
}
