% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mvord}
\alias{predict.mvord}
\title{Predict method for Multivariate Ordinal Regression Models.}
\usage{
\method{predict}{mvord}(
  object,
  newdata = NULL,
  type = NULL,
  subjectID = NULL,
  newoffset = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{'mvord'}.}

\item{newdata}{(optional) data frame of new covariates and new responses.}

\item{type}{types \code{"class"}, \code{"prob"} and \code{"cum.prob"} are available.}

\item{subjectID}{(optional) vector specifying for which subjectIDs the predictions\cr or fitted values should be computed.}

\item{newoffset}{(optional) list of length equal to the number of outcomes, each element containing a vector of offsets to be considered.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Obtains predicted or fitted values for objects of class \code{'mvord'}.
}
\details{
\tabular{ll}{
  \code{type} \tab description\cr
  \code{"class"} \tab combination of response categories with the highest probability. Used as default if newdata contains no column(s) for response variable(s) or all responses are NA.\cr
  \code{"prob"} \tab fitted joint probability for the observed response categories \cr
  \tab or the categories provided in the response column(s) in \code{newdata}. Used as default if newdata contains column(s) for response variable(s).\cr
  \tab If response column(s) in \code{newdata} contain only NAs or is missing, this type is not supported.\cr
  \code{"cum.prob"} \tab fitted joint cumulative probability for the observed response\cr
  \tab categories or the categories provided in the response column(s) in \code{newdata}.\cr
  \tab If response column(s) in \code{newdata} contain only NAs or is missing, this type is not supported.\cr
  }
If provided, the (row) names of the output correspond to the subjectIDs,
otherwise they correspond to the row id of the observations.
}
\seealso{
\code{\link{marginal_predict}}, \code{\link{joint_probabilities}}
}
