% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.mvgam.R
\name{update.mvgam}
\alias{update.mvgam}
\alias{update.jsdgam}
\title{Update an existing \pkg{mvgam} model object}
\usage{
\method{update}{mvgam}(
  object,
  formula,
  trend_formula,
  knots,
  trend_knots,
  trend_model,
  family,
  share_obs_params,
  data,
  newdata,
  trend_map,
  use_lv,
  n_lv,
  priors,
  chains,
  burnin,
  samples,
  threads,
  algorithm,
  lfo = FALSE,
  ...
)

\method{update}{jsdgam}(
  object,
  formula,
  factor_formula,
  knots,
  factor_knots,
  data,
  newdata,
  n_lv,
  family,
  share_obs_params,
  priors,
  chains,
  burnin,
  samples,
  threads,
  algorithm,
  lfo = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{list} object returned from \code{mvgam}. See \code{\link[=mvgam]{mvgam()}}}

\item{formula}{Optional new \code{formula} object. Note, \code{mvgam} currently does
not support dynamic formula updates such as removal of specific terms with
\code{- term}. When updating, the entire formula needs to be supplied.}

\item{trend_formula}{An optional \code{formula} object specifying the GAM process
model formula. If supplied, a linear predictor will be modelled for the
latent trends to capture process model evolution separately from the
observation model.

\strong{Important notes:}
\itemize{
\item Should not have a response variable specified on the left-hand side
(e.g., \code{~ season + s(year)})
\item Use \code{trend} instead of \code{series} for effects that vary across time series
\item Only available for \code{RW()}, \code{AR()} and \code{VAR()} trend models
\item In \code{nmix()} family models, sets up linear predictor for latent abundance
\item Consider dropping one intercept using \code{- 1} convention to avoid
estimation challenges
}}

\item{knots}{An optional \code{list} containing user specified knot values for
basis construction. For most bases the user simply supplies the knots to be
used, which must match up with the \code{k} value supplied. Different terms can
use different numbers of knots, unless they share a covariate.}

\item{trend_knots}{As for \code{knots} above, this is an optional \code{list} of knot
values for smooth functions within the \code{trend_formula}.}

\item{trend_model}{\code{character} or \code{function} specifying the time series dynamics
for the latent trend.

\strong{Available options:}
\itemize{
\item \code{None}: No latent trend component (GAM component only, like \code{\link[mgcv]{gam}})
\item \code{ZMVN} or \code{ZMVN()}: Zero-Mean Multivariate Normal (Stan only)
\item \code{'RW'} or \code{RW()}: Random Walk
\item \code{'AR1'}, \code{'AR2'}, \code{'AR3'} or \code{AR(p = 1, 2, 3)}: Autoregressive models
\item \code{'CAR1'} or \code{CAR(p = 1)}: Continuous-time AR (Ornstein–Uhlenbeck process)
\item \code{'VAR1'} or \code{VAR()}: Vector Autoregressive (Stan only)
\item \code{'PWlogistic'}, \code{'PWlinear'} or \code{PW()}: Piecewise trends (Stan only)
\item \code{'GP'} or \code{GP()}: Gaussian Process with squared exponential kernel (Stan only)
}

\strong{Additional features:}
\itemize{
\item Moving average and/or correlated process error terms available for most types
(e.g., \code{RW(cor = TRUE)} for multivariate Random Walk)
\item Hierarchical correlations possible for structured data
\item See \link{mvgam_trends} for details and \code{\link[=ZMVN]{ZMVN()}} for examples
}}

\item{family}{\code{family} specifying the exponential observation family for the series.

\strong{Supported families:}
\itemize{
\item \code{gaussian()}: Real-valued data
\item \code{betar()}: Proportional data on \verb{(0,1)}
\item \code{lognormal()}: Non-negative real-valued data
\item \code{student_t()}: Real-valued data
\item \code{Gamma()}: Non-negative real-valued data
\item \code{bernoulli()}: Binary data
\item \code{poisson()}: Count data (default)
\item \code{nb()}: Overdispersed count data
\item \code{binomial()}: Count data with imperfect detection when number of trials is known
(use \code{cbind()} to bind observations and trials)
\item \code{beta_binomial()}: As \code{binomial()} but allows for overdispersion
\item \code{nmix()}: Count data with imperfect detection when number of trials is unknown
(State-Space N-Mixture model with Poisson latent states and Binomial observations)
}

See \code{\link{mvgam_families}} for more details.}

\item{share_obs_params}{\code{logical}. If \code{TRUE} and the \code{family} has additional
family-specific observation parameters (e.g., variance components, dispersion
parameters), these will be shared across all outcome variables. Useful when
multiple outcomes share properties. Default is \code{FALSE}.}

\item{data}{A \code{dataframe} or \code{list} containing the model response variable
and covariates required by the GAM \code{formula} and optional \code{trend_formula}.

\strong{Required columns for most models:}
\itemize{
\item \code{series}: A \code{factor} index of the series IDs (number of levels should equal
number of unique series labels)
\item \code{time}: \code{numeric} or \code{integer} index of time points. For most dynamic trend
types, time should be measured in discrete, regularly spaced intervals
(i.e., \code{c(1, 2, 3, ...)}). Irregular spacing is allowed for \code{trend_model = CAR(1)},
but zero intervals are adjusted to \code{1e-12} to prevent sampling errors.
}

\strong{Special cases:}
\itemize{
\item Models with hierarchical temporal correlation (e.g., \code{AR(gr = region, subgr = species)})
should NOT include a \code{series} identifier
\item Models without temporal dynamics (\code{trend_model = 'None'} or \code{trend_model = ZMVN()})
don't require a \code{time} variable
}}

\item{newdata}{Optional \code{dataframe} or \code{list} of test data containing the same
variables as in \code{data}. If included, observations in variable \code{y} will be
set to \code{NA} when fitting the model so that posterior simulations can be obtained.}

\item{trend_map}{Optional \code{data.frame} specifying which series should depend on
which latent trends. Enables multiple series to depend on the same latent
trend process with different observation processes.

\strong{Required structure:}
\itemize{
\item Column \code{series}: Single unique entry for each series (matching factor levels in data)
\item Column \code{trend}: Integer values indicating which trend each series depends on
}

\strong{Notes:}
\itemize{
\item Sets up latent factor model by enabling \code{use_lv = TRUE}
\item Process model intercept is NOT automatically suppressed
\item Not yet supported for continuous time models (\code{CAR()})
}}

\item{use_lv}{\code{logical}. If \code{TRUE}, use dynamic factors to estimate series'
latent trends in a reduced dimension format. Only available for \code{RW()},
\code{AR()} and \code{GP()} trend models. Default is \code{FALSE}.
See \code{\link{lv_correlations}} for examples.}

\item{n_lv}{\code{integer} specifying the number of latent dynamic factors to use
if \code{use_lv == TRUE}. Cannot exceed \code{n_series}. Default is
\code{min(2, floor(n_series / 2))}.}

\item{priors}{An optional \code{data.frame} with prior definitions or, preferably,
a vector of \code{brmsprior} objects (see \code{\link[brms]{prior}()}).
See \code{\link[=get_mvgam_priors]{get_mvgam_priors()}} and Details for more information.}

\item{chains}{\code{integer} specifying the number of parallel chains for the model.
Ignored for variational inference algorithms.}

\item{burnin}{\code{integer} specifying the number of warmup iterations to tune
sampling algorithms. Ignored for variational inference algorithms.}

\item{samples}{\code{integer} specifying the number of post-warmup iterations for
sampling the posterior distribution.}

\item{threads}{\code{integer}. Experimental option for within-chain parallelisation
in Stan using \code{reduce_sum}. Recommended only for experienced Stan users with
slow models. Currently works for all families except \code{nmix()} and when using
Cmdstan backend.}

\item{algorithm}{Character string naming the estimation approach:
\itemize{
\item \code{"sampling"}: MCMC (default)
\item \code{"meanfield"}: Variational inference with factorized normal distributions
\item \code{"fullrank"}: Variational inference with multivariate normal distribution
\item \code{"laplace"}: Laplace approximation (cmdstanr only)
\item \code{"pathfinder"}: Pathfinder algorithm (cmdstanr only)
}

Can be set globally via \code{"brms.algorithm"} option. Limited testing suggests
\code{"meanfield"} performs best among non-MCMC approximations for dynamic GAMs.}

\item{lfo}{\code{logical}. Indicates whether this is part of \link{lfo_cv.mvgam} call.
Returns lighter model version for speed. Users should leave as \code{FALSE}.}

\item{...}{Other arguments to be passed to \code{\link{mvgam}} or
\code{\link{jsdgam}}}

\item{factor_formula}{Optional new \code{formula} object for the factor linear
predictors}

\item{factor_knots}{An optional \code{list} containing user specified knot
values to be used for basis construction of any smooth terms in
\code{factor_formula}. For most bases the user simply supplies the knots to be
used, which must match up with the \code{k} value supplied (note that the
number of knots is not always just \code{k}). Different terms can use different
numbers of knots, unless they share a covariate}
}
\value{
A \code{list} object of class \code{mvgam} containing model output,
the text representation of the model file, the mgcv model output (for
easily generating simulations at unsampled covariate values), Dunn-Smyth
residuals for each outcome variable and key information needed for other
functions in the package. See \code{\link{mvgam-class}} for details. Use
\code{methods(class = "mvgam")} for an overview on available methods.

A \code{list} object of class \code{mvgam} containing model output,
the text representation of the model file, the mgcv model output (for
easily generating simulations at unsampled covariate values), Dunn-Smyth
residuals for each series and key information needed for other functions in
the package. See \code{\link{mvgam-class}} for details. Use
\code{methods(class = "mvgam")} for an overview on available methods.
}
\description{
This function allows a previously fitted \pkg{mvgam} model to be updated.
}
\examples{
\donttest{
# Simulate some data and fit a Poisson AR1 model
simdat <- sim_mvgam(n_series = 1, trend_model = AR())

mod <- mvgam(
  y ~ s(season, bs = 'cc'),
  trend_model = AR(),
  noncentred = TRUE,
  data = simdat$data_train,
  chains = 2
)

summary(mod)
conditional_effects(mod, type = 'link')

# Update to an AR2 model
updated_mod <- update(
  mod,
  trend_model = AR(p = 2),
  noncentred = TRUE
)

summary(updated_mod)
conditional_effects(updated_mod, type = 'link')

# Now update to a Binomial AR1 by adding information on trials
# requires that we supply newdata that contains the 'trials' variable
simdat$data_train$trials <- max(simdat$data_train$y) + 15

updated_mod <- update(
  mod,
  formula = cbind(y, trials) ~ s(season, bs = 'cc'),
  noncentred = TRUE,
  data = simdat$data_train,
  family = binomial()
)

summary(updated_mod)
conditional_effects(updated_mod, type = 'link')
}

}
\author{
Nicholas J Clark
}
