
<!-- README.md is generated from README.Rmd. Please edit that file -->

# mvabund <img src="man/figures/mvabund_hex.png" align="right" alt="" width="150" />

<!-- badges: start -->

[![](https://img.shields.io/badge/doi-10.1111/j.2041--210X.2012.00190.x-orange.svg)](https://doi.org/10.1111/j.2041-210X.2012.00190.x)
[![License](http://img.shields.io/badge/license-LGPL%20%28%3E=%202.1%29-brightgreen.svg?style=flat)](http://www.gnu.org/licenses/gpl-2.0.html)
[![CRAN
status](https://www.r-pkg.org/badges/version/mvabund)](https://CRAN.R-project.org/package=mvabund)
[![](http://cranlogs.r-pkg.org/badges/last-month/mvabund)](https://cran.r-project.org/package=mvabund)
[![Codecov test
coverage](https://codecov.io/gh/eco-stats/mvabund/branch/master/graph/badge.svg)](https://app.codecov.io/gh/eco-stats/mvabund?branch=master)

<!-- badges: end -->

The goal of mvabund is to provide tools for a **model-based approach**
to the analysis of multivariate abundance data in ecology [(Yi Wang et
al. 2011)](https://besjournals.onlinelibrary.wiley.com/doi/10.1111/j.2041-210X.2012.00190.x),
in particular, testing hypothesis about the community-environment
association. Abundance measures include counts, presence/absence data,
ordinal or biomass data.

This package includes functions for **visualising data, fitting
predictive models, checking model assumptions, as well as testing
hypotheses about the community–environment association**.

### Installation

`mvabund` is available on
[CRAN](https://CRAN.R-project.org/package=mvabund) and can be installed
directly in R:

``` r
install.packages("mvabund")

library(mvabund)
```

Alternatively, you can install the **development** version of `mvabund`
from [GitHub](https://github.com/) with:

``` r
# install.packages("remotes")
remotes::install_github("eco-stats/mvabund")

library(mvabund)
```

### Getting Started

We highly recommend you taking a good read of our vignette over at [our
website]() before launching into the `mvabund`. Alternatively, you can
access the vignettes in R by:

``` r
remotes::install_github("eco-stats/mvabund", build_vignettes = TRUE)

vignette("mvabund")
```

### Show `mvabund` your support

``` r
citation("mvabund")
#> To cite package 'mvabund' in publications use:
#> 
#>   Wang Y, Naumann U, Eddelbuettel D, Wilshire J, Warton D (2022).
#>   _mvabund: Statistical Methods for Analysing Multivariate Abundance
#>   Data_. R package version 4.2.1,
#>   <https://CRAN.R-project.org/package=mvabund>.
#> 
#> A BibTeX entry for LaTeX users is
#> 
#>   @Manual{,
#>     title = {mvabund: Statistical Methods for Analysing Multivariate Abundance Data},
#>     author = {Yi Wang and Ulrike Naumann and Dirk Eddelbuettel and John Wilshire and David Warton},
#>     year = {2022},
#>     note = {R package version 4.2.1},
#>     url = {https://CRAN.R-project.org/package=mvabund},
#>   }
```

### Spot a bug?

Thanks for finding the bug! We would appreciate it if you can pop over
to our [Issues page](https://github.com/eco-stats/mvabund/issues) and
describe how to reproduce the bug!

### Other resources

- [Online
  tutorial](https://environmentalcomputing.net/statistics/mvabund/) for
  using `mvabund` for comparing species composition across different
  habitats
- [Video
  introduction](http://eco-stats.blogspot.com/2012/03/introducing-mvabund-package-and-why.html)
  to `mvabund`

### mvabund in action

Check out the list of studies that uses `mvabund` in their analyses
[here](https://scholar.google.com.au/scholar?cites=2455431763697722063)
