% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_pca.R
\name{bootstrap.pca}
\alias{bootstrap.pca}
\title{PCA Bootstrap Resampling}
\usage{
\method{bootstrap}{pca}(x, nboot = 100, k = ncomp(x), ...)
}
\arguments{
\item{x}{A fitted PCA model object.}

\item{nboot}{The number of bootstrap resamples (default: 100).}

\item{k}{The number of components to bootstrap (default: all components in the fitted PCA model).}

\item{...}{Additional arguments to be passed to the specific model implementation of \code{bootstrap}.}
}
\value{
A \code{list} containing bootstrap z-scores for the loadings (\code{zboot_loadings}) and scores (\code{zboot_scores}).
}
\description{
Perform bootstrap resampling for Principal Component Analysis (PCA) to estimate component and score variability.
}
\examples{
X <- matrix(rnorm(10*100), 10, 100)
x <- pca(X, ncomp=9)
bootstrap_results <- bootstrap(x)

}
\references{
Fisher, Aaron, Brian Caffo, Brian Schwartz, and Vadim Zipunnikov. 2016.
"Fast, Exact Bootstrap Principal Component Analysis for P > 1 Million." \emph{Journal of the American Statistical Association} 111 (514): 846-60.
}
\concept{bootstrap}
