% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVR.r
\name{mvfd}
\alias{mvfd}
\title{mvfd Main function to calculate functional richness}
\usage{
mvfd(
  in.mat,
  in.com = "none",
  unequal.abund = F,
  resolution = 0,
  st.range = 0,
  log.trans = 0,
  col.mins = "use data",
  col.maxs = "use data",
  traitspace = "use data",
  calc.ovr = 1,
  force.matrix = TRUE
)
}
\arguments{
\item{in.mat}{A record x trait matrix.  Needs to be in matrix format, not as a dataframe}

\item{in.com}{A community x species matrix.  If only one community with all the species is considered, you can enter "none", and the code will auto-create the community needed for the script.}

\item{unequal.abund}{A feature not currently in script, intended as an option to indicate whether abundance data should be incorporated.}

\item{resolution}{This input controls rounding of the data (categorization was acheived by rounding for simplicity).  0 indicates integers, 1 = 1 decimal place, 2 = 2 decimal places, -1 = 10's place., etc.)}

\item{st.range}{Option to control range standardization.  This was never properly scripted and should remain 0.  Any desired range transformations should be done prior to this script.}

\item{log.trans}{Option to control whether or not data are log transformed.  This has not been properly tested as I found it easier to log-transform the data manually in Excel.}

\item{col.mins}{If option is "use data" the function will get the minimum from the data.  Otherwise a vector of minimum values to use can be specified}

\item{col.maxs}{If option is "use data" the function will get the maximum values from the data.  Otherwise a vector of maximum values can be specified.}

\item{traitspace}{If set to "use data", the function will estimate the traitspace as the product of trait ranges.  Otherwise, the specified traitspace will be used for scaling (e.g., if you want to input a traitspace based on a convex hull)}

\item{calc.ovr}{An option to determine whether overlap is calculated.  This may be slow or buggy, so in some cases it may be easier to turn it off.}

\item{force.matrix}{an option to determine whether to try to force an input into matrix format}
}
\description{
Main function to calculate multivariate richness.
Goal is to mirror format of dbfd from Laliberte & Shipley 2011.
}
\details{
Currently takes a record x trait matrix and an optional community matrix.
}
\examples{
# Compare functional diveristy between species using the Iris dataset
ind.mat = iris
ind.mat$Species = NULL
ind.lbl = sprintf("Ind_\%s",seq(1,nrow(iris)))
ind.mat = as.matrix(ind.mat) #Needs to be in matrix format
rownames(ind.mat) = ind.lbl
com.base = iris$Species
pool = rep(1,nrow(iris))
com1 = sapply(com.base, function(x){ifelse(x == "setosa",1,0)})
com2 = sapply(com.base, function(x){ifelse(x == "versicolor",1,0)})
com3 = sapply(com.base, function(x){ifelse(x == "virginica",1,0)})
com.vec = c(pool,com1,com2,com3)
com.lbl = c("pool","com1","com2","com3")
com.mat = matrix(com.vec,nrow = 4,byrow = TRUE,dimnames = list(com.lbl,ind.lbl))

mvr.out = mvfd(ind.mat,com.mat)
}
\author{
A.C. Keyel
}
