% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_interactions.R
\name{classify_interactions}
\alias{classify_interactions}
\title{Classify Interactions (for either null model)}
\usage{
classify_interactions(
  effect_size_dataframe,
  assign_reversals,
  remove_directionality
)
}
\arguments{
\item{effect_size_dataframe}{Output from either the \code{\link{effect_size_additive}} or \code{\link{effect_size_multiplicative}} functions.}

\item{assign_reversals}{Specify whether reversals should be distinguished from antagonisms (see \emph{Jackson et al. (2016)}
(TRUE or FALSE; default = TRUE)}

\item{remove_directionality}{Specify whether directionality should be removed from the effect sizes.
This is most pertinent where subsequent analyses will involve conducting a formal meta-analysis (set value to TRUE).
(TRUE or FALSE; default = FALSE)}
}
\value{
The function returns a dataset containing
i)   the same results as from either the \code{\link{effect_size_additive}} or \code{\link{effect_size_multiplicative}} functions.

ii)  the classification of any interactions (see below)

iii) if remove_directionality = TRUE; effect sizes, and confidence intervals will be adjusted (see below)

---

---

For ii), interactions are classified in the following method.

 a) if the confidence intervals for any effect size overlap zero then the interaction is assigned a \emph{null} classification.

 This is analogous to the classification of \emph{additive} which other studies (e.g., \emph{Jackson et al. (2016)}) may use.

 Note that this is given precedence over the process described in b).


 ---

 b) if the confidence intervals for any effect size do not overlap zero then \emph{Expected} and \emph{Observed} effects are calculated.

 Where the additive null model has been used:
 \deqn{Expected = X_a + X_b - 2 * X_c}
 \deqn{Observed = X_i - X_c}

 Where the multiplicative null model has been used:
 \deqn{Expected = ln(X_a) + ln(X_b) - 2 * ln(X_c)}
 \deqn{Observed = ln(X_i) - ln(X_c)}

 Here \emph{X_c}, \emph{X_a}, \emph{X_b}, and \emph{X_i} correspond to the means of the control,
 stressor A, stressor B, and stressors A and B treatments respectively.

 ---

 A \emph{synergistic} classification is assigned where:

 an effect size is positive \emph{and} \emph{Expected} is greater than zero.

 or

 an effect size is negative \emph{and} \emph{Expected} is less than zero.

 ---

 An \emph{antagonistic} classification is assigned where:

 an effect size is negative \emph{and both} \emph{Expected and Observed} are greater than zero.

 or

 an effect size is positive \emph{and both} \emph{Expected and Observed} are less than zero.

 ---

 A \emph{reversal} classification is assigned where:

 an effect size is negative \emph{and} \emph{Expected} is greater than zero but \emph{Observed} is less than zero.

 or

 an effect size is positive \emph{and} \emph{Expected} is less than zero but \emph{Observed} is greater than zero.


 If \emph{assign_reversals} = FALSE, then where a reversal would be assigned using the above method, it is simply assigned
 an \emph{antagonistic} classification instead.

---

---

 If \emph{remove_directionality} = TRUE, then the following method is implemented.

 Where an interaction has an \emph{Expected} value <0, the corresponding effect size
 for this interaction has its polarity changed (i.e., ES = -ES).

 Confidence intervals for these altered effect sizes are likewise updated.

 The remove of directionality is only likely to be of concern for meta-analyses.
}
\description{
Using the output from either the \code{\link{effect_size_additive}} or \code{\link{effect_size_multiplicative}} functions,
interactions can be assigned classifications (e.g., antagonisms or synergisms) based on the frameworks used by
\emph{Burgess et al. (2021)}, or \emph{Jackson et al. (2016)}.
}
\examples{

#loading up an example dataset from the multiplestressR package
df <- multiplestressR::survival

#calculating effect sizes
df <- effect_size_additive(Control_N         = df$Sample_Size_Control,
                           Control_SD        = df$Standard_Deviation_Control,
                           Control_Mean      = df$Mean_Control,
                           StressorA_N       = df$Sample_Size_Temperature,
                           StressorA_SD      = df$Standard_Deviation_Temperature,
                           StressorA_Mean    = df$Mean_Temperature,
                           StressorB_N       = df$Sample_Size_pH,
                           StressorB_SD      = df$Standard_Deviation_pH,
                           StressorB_Mean    = df$Mean_pH,
                           StressorsAB_N     = df$Sample_Size_Temperature_pH,
                           StressorsAB_SD    = df$Standard_Deviation_Temperature_pH,
                           StressorsAB_Mean  = df$Mean_Temperature_pH,
                           Significance_Level = 0.05);

#classifying interactions
df <- classify_interactions(effect_size_dataframe = df,
                   assign_reversals = TRUE,
                   remove_directionality = TRUE)


}
\references{
Burgess, B. J., Purves, D., Mace, G., & Murrell, D. J. (2021). Classifying ecosystem stressor interactions: Theory highlights the data limitations of the additive null model and the difficulty in revealing ecological surprises. \emph{Global Change Biology}.

Jackson, M. C., Loewen, C. J., Vinebrooke, R. D., & Chimimba, C. T. (2016). Net effects of multiple stressors in freshwater ecosystems: a meta-analysis. \emph{Global Change Biology}, 22(1), 180-189.
}
