% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_Z_discrete.r
\name{make_Z_discrete}
\alias{make_Z_discrete}
\title{Make initial Z matrix from initial assignment of observations to clusters}
\usage{
make_Z_discrete(d)
}
\arguments{
\item{d}{integer}
}
\value{
a \code{matrix} whose entries are non-negative, and whose entries sum to 1.
}
\description{
Z is an \eqn{n}{n} by \eqn{numClusters}{numClusters} matrix of non-negative numbers whose rows
sum to 1. The \eqn{ij^{\mathrm{th}}}{ij^th} element \eqn{z_{ij}}{z_ij} is a
probability that observation \eqn{i}{i} belongs to cluster \eqn{j}{j}. Rather
than begin from an initial assignment Multimix allows for a weighted
assignment accross several clusters.
}
\details{
This function yields a 0/1 valued matrix.
}
\examples{
stage = scan(file = system.file('extdata', 'Stage.txt', package = 'multimix'))
stage = stage - 2
Z = make_Z_discrete(stage)
}
\author{
Murray Jorgensen
}
