% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_sensitivity}
\alias{plot_sensitivity}
\title{Generic Sensitivity Plot}
\usage{
plot_sensitivity(sensitivity_curve, x_var = "rho", y_var = "indirect_effect")
}
\arguments{
\item{sensitivity_curve}{The output of a call to sensitivity or
sensitivity_perturb. A data.frame whose columns are: outcome, \{x_var\},
\{y_var\}, and \{y_var\}_standard_error, where x_var and y_var are defined
in the two arguments below.}

\item{x_var}{The type of perturbation variable to plot along the x-axis.
Defaults to "rho", following the sensitivity approach implemented in
sensitivity_subset.}

\item{y_var}{The type of effect to plot along the y-axis. Defaults to
indirect_effect.}
}
\value{
A ggplot2 grob plotting the sensitivity parameter against the effect
specified by \code{y_var}.
}
\description{
This function draws a curve of indirect effect against the sensitivity
parameter, allowing users to specify the name of x and y-axis variables using
the x_var and y_var inputs.
}
\examples{
sensitivity_curve <- read.csv(url("https://go.wisc.edu/j2kvcj"))
plot_sensitivity(sensitivity_curve)
}
