% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediation.R
\name{multimedia}
\alias{multimedia}
\title{\code{multimedia} Constructor}
\usage{
multimedia(
  mediation_data,
  outcome_estimator = lm_model(),
  mediation_estimator = lm_model()
)
}
\arguments{
\item{mediation_data}{An object of class \code{mediation_data}, with separate
slots for each of the node types in a mediation analysis diagram.}

\item{outcome_estimator}{An object of class \code{model} that will be used to
estimate the outcome model.}

\item{mediation_estimator}{An object of class \code{model} that will be used to
estimate the mediation model.}
}
\value{
An object of class \code{multimedia} encapsulating the full mediation
model and data.
}
\description{
\code{multimedia} objects encapsulate the model and data that underlie a mediation
analysis, together with metadata (like graph structure) that contextualize
the estimation. This function can be used to construct a new multimedia
instances from a \code{mediation_data} dataset and pair of estimators.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper)

exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper)

# real data example with a pretreatment variable
data(mindfulness)
exper <- mediation_data(
    mindfulness,
    phyloseq::taxa_names(mindfulness),
    "treatment",
    starts_with("mediator"),
    "subject"
)
multimedia(exper)
}
\seealso{
multimedia-class
}
